/*
 * Decompiled with CFR 0.152.
 */
package com.github.czietsman.lz4;

import com.github.czietsman.lz4.LZ4Compressor;
import com.github.czietsman.lz4.LZ4FastDecompressor;
import com.github.czietsman.lz4.LZ4HCJavaSafeCompressor;
import com.github.czietsman.lz4.LZ4JavaSafeCompressor;
import com.github.czietsman.lz4.LZ4JavaSafeFastDecompressor;
import com.github.czietsman.lz4.LZ4JavaSafeSafeDecompressor;
import com.github.czietsman.lz4.LZ4SafeDecompressor;
import java.util.Arrays;

public final class LZ4Factory {
    public static LZ4Factory INSTANCE = new LZ4Factory();
    private final LZ4Compressor fastCompressor;
    private final LZ4Compressor highCompressor;
    private final LZ4FastDecompressor fastDecompressor;
    private final LZ4SafeDecompressor safeDecompressor;
    private final LZ4Compressor[] highCompressors = new LZ4Compressor[18];

    private LZ4Factory() {
        this.fastCompressor = LZ4JavaSafeCompressor.INSTANCE;
        this.highCompressor = LZ4HCJavaSafeCompressor.INSTANCE;
        this.fastDecompressor = LZ4JavaSafeFastDecompressor.INSTANCE;
        this.safeDecompressor = LZ4JavaSafeSafeDecompressor.INSTANCE;
        this.highCompressors[9] = this.highCompressor;
        for (int level = 1; level <= 17; ++level) {
            if (level == 9) continue;
            this.highCompressors[level] = new LZ4HCJavaSafeCompressor(level);
        }
        byte[] original = new byte[]{97, 98, 99, 100, 32, 32, 32, 32, 32, 32, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106};
        for (LZ4Compressor compressor : Arrays.asList(this.fastCompressor, this.highCompressor)) {
            int maxCompressedLength = compressor.maxCompressedLength(original.length);
            byte[] compressed = new byte[maxCompressedLength];
            int compressedLength = compressor.compress(original, 0, original.length, compressed, 0, maxCompressedLength);
            byte[] restored = new byte[original.length];
            this.fastDecompressor.decompress(compressed, 0, restored, 0, original.length);
            if (!Arrays.equals(original, restored)) {
                throw new AssertionError();
            }
            Arrays.fill(restored, (byte)0);
            int decompressedLength = this.safeDecompressor.decompress(compressed, 0, compressedLength, restored, 0);
            if (decompressedLength != original.length || !Arrays.equals(original, restored)) {
                throw new AssertionError();
            }
        }
    }

    public LZ4Compressor fastCompressor() {
        return this.fastCompressor;
    }

    public LZ4Compressor highCompressor() {
        return this.highCompressor;
    }

    public LZ4Compressor highCompressor(int compressionLevel) {
        if (compressionLevel > 17) {
            compressionLevel = 17;
        } else if (compressionLevel < 1) {
            compressionLevel = 9;
        }
        return this.highCompressors[compressionLevel];
    }

    public LZ4FastDecompressor fastDecompressor() {
        return this.fastDecompressor;
    }

    public LZ4SafeDecompressor safeDecompressor() {
        return this.safeDecompressor;
    }
}

