/*
 * Decompiled with CFR 0.152.
 */
package com.github.curiousoddman.rgxgen.iterators;

import com.github.curiousoddman.rgxgen.iterators.StringIterator;
import java.util.Arrays;
import java.util.NoSuchElementException;

public class ChoiceIterator
extends StringIterator {
    private final StringIterator[] aIterators;
    private int aCurrentIteratorIndex;

    public ChoiceIterator(StringIterator[] iterators) {
        this.aIterators = iterators;
    }

    @Override
    public boolean hasNext() {
        return this.aIterators[this.aCurrentIteratorIndex].hasNext() || this.aCurrentIteratorIndex + 1 < this.aIterators.length;
    }

    @Override
    public String nextImpl() {
        if (!this.aIterators[this.aCurrentIteratorIndex].hasNext()) {
            ++this.aCurrentIteratorIndex;
            if (this.aCurrentIteratorIndex >= this.aIterators.length) {
                throw new NoSuchElementException("No more values");
            }
        }
        return this.aIterators[this.aCurrentIteratorIndex].next();
    }

    @Override
    public String current() {
        return this.aIterators[this.aCurrentIteratorIndex].current();
    }

    @Override
    public void reset() {
        this.aCurrentIteratorIndex = 0;
        for (StringIterator iterator : this.aIterators) {
            iterator.reset();
        }
    }

    public String toString() {
        return "ChoiceIterator{aIterators=" + Arrays.toString(this.aIterators) + ", aCurrentIteratorIndex=" + this.aCurrentIteratorIndex + '}';
    }
}

