/*
 * Decompiled with CFR 0.152.
 */
package cfml.dictionary;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Trigger {
    protected HashMap triggerParams = new HashMap();
    protected boolean isRequired = false;
    protected int index = -1;

    public static Trigger CreateSimpleTrigger(String paramName, String paramVal) {
        return Trigger.CreateSimpleTrigger(paramName, paramVal, false);
    }

    public static Trigger CreateSimpleTrigger(String paramName, String paramVal, boolean required) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(paramName, paramVal);
        return new Trigger(params, required);
    }

    public static Trigger CreateSimpleTrigger(String paramName, String paramVal, boolean required, int index) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(paramName, paramVal);
        return new Trigger(params, required, index);
    }

    Trigger(HashMap newParams) {
        this.triggerParams = newParams;
    }

    Trigger(HashMap newParams, boolean required) {
        this.isRequired = required;
        this.triggerParams = newParams;
    }

    Trigger(HashMap newParams, boolean required, int index) {
        this.isRequired = required;
        this.index = index;
        this.triggerParams = newParams;
    }

    private boolean mapsEqual(Map m1, Map m2) {
        if (!m1.keySet().equals(m2.keySet())) {
            return false;
        }
        for (Object key : m1.keySet()) {
            if (m1.get(key) == null) {
                return false;
            }
            if (m2.get(key) == null) {
                return false;
            }
            if (m1.get(key).equals(m2.get(key))) continue;
            return false;
        }
        return true;
    }

    public int WillTrigger(HashMap params) {
        if (this.triggerParams.size() == 0) {
            return 1 | (this.isRequired ? 2 : 0);
        }
        if (this.mapsEqual(this.triggerParams, params)) {
            if (this.isRequired) {
                return 3;
            }
            return 1;
        }
        Set paramSet = params.keySet();
        for (Object key : paramSet) {
            String value = params.get(key).toString();
            HashMap<String, String> thisParam = new HashMap<String, String>();
            thisParam.put(key.toString(), value);
            if (!this.triggerParams.toString().equalsIgnoreCase(thisParam.toString())) continue;
            if (this.isRequired) {
                return 3;
            }
            return 1;
        }
        return 0;
    }

    public String toString() {
        return this.triggerParams.toString();
    }

    public int paramIndex() {
        return this.index;
    }
}

