/*
 * Decompiled with CFR 0.152.
 */
package cfml.dictionary;

import cfml.dictionary.Component;
import cfml.dictionary.Function;
import cfml.dictionary.Parameter;
import cfml.dictionary.Procedure;
import cfml.dictionary.ScopeVar;
import cfml.dictionary.Tag;
import cfml.dictionary.Trigger;
import cfml.dictionary.Value;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class DictionaryContentHandler
implements ContentHandler {
    private Map dtags;
    private Map dfunctions;
    private Map dscopeVars;
    private Map dscopes;
    private String currenttag = "";
    private Procedure currentitem = null;
    private Parameter paramItem = null;
    private Function methoditem = null;
    private boolean inTriggerBlock = false;

    public DictionaryContentHandler(Map tags, Map functions, Map scopeVars, Map scopes) {
        this.dtags = tags;
        this.dfunctions = functions;
        this.dscopeVars = scopeVars;
        this.dscopes = scopes;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    private boolean parseBoolean(String bstring) {
        return bstring.equalsIgnoreCase("true") || bstring.equalsIgnoreCase("yes");
    }

    private void handleTriggersStart(Attributes attribs) {
        if (this.paramItem == null) {
            System.err.println("Got a <triggers> block outside of a parameter!");
        } else {
            this.inTriggerBlock = true;
        }
    }

    private void handleTriggersEnd() {
        this.inTriggerBlock = false;
    }

    private void handleSelectedValue(Attributes attributes) {
        if (!this.inTriggerBlock) {
            System.err.println("Got a <selectedValue> outside of a valid triggers block!");
            return;
        }
        String attrName = attributes.getValue("attributeName");
        String value = attributes.getValue("value");
        boolean required = attributes.getValue("required").compareToIgnoreCase("true") == 0;
        String indexVal = attributes.getValue("index");
        int index = -1;
        if (indexVal != null) {
            index = Integer.parseInt(indexVal);
        }
        this.paramItem.addTrigger(Trigger.CreateSimpleTrigger(attrName, value, required, index));
    }

    @Override
    public void startElement(String namespace, String localName, String str2, Attributes attributes) throws SAXException {
        this.currenttag = str2.toLowerCase();
        if (str2.equals("tag")) {
            this.handleTagStart(attributes);
        } else if (str2.equals("function")) {
            this.handleFunctionStart(attributes);
        } else if (str2.equals("parameter")) {
            this.handleParameterStart(attributes);
        } else if (str2.equals("value")) {
            this.handleValueStart(attributes);
        } else if (!str2.equals("help")) {
            if (str2.equals("component")) {
                this.handleComponentStart(attributes);
            } else if (str2.equals("scope")) {
                this.handleScopeStart(attributes);
            } else if (str2.equals("triggers")) {
                this.handleTriggersStart(attributes);
            } else if (str2.equals("selectedValue")) {
                this.handleSelectedValue(attributes);
            }
        }
    }

    private void handleTagStart(Attributes attributes) {
        byte creator = 0;
        String name = "";
        boolean single = false;
        boolean xmlstyle = false;
        boolean hybrid = false;
        boolean anyAttribute = false;
        boolean endtagrequired = false;
        for (int x = 0; x < attributes.getLength(); ++x) {
            String attrname = attributes.getQName(x).toLowerCase();
            if (attrname.equals("creator")) {
                creator = Byte.parseByte(attributes.getValue(x));
                continue;
            }
            if (attrname.equals("name")) {
                name = attributes.getValue(x);
                continue;
            }
            if (attrname.equals("single")) {
                single = this.parseBoolean(attributes.getValue(x));
                continue;
            }
            if (attrname.equals("xmlstyle")) {
                xmlstyle = this.parseBoolean(attributes.getValue(x));
                continue;
            }
            if (attrname.equals("hybrid")) {
                hybrid = this.parseBoolean(attributes.getValue(x));
                continue;
            }
            if (attrname.equals("allowanyattribute")) {
                anyAttribute = this.parseBoolean(attributes.getValue(x));
                continue;
            }
            if (!attrname.equals("endtagrequired")) continue;
            endtagrequired = this.parseBoolean(attributes.getValue(x));
        }
        this.currentitem = new Tag(name, single, xmlstyle, creator, hybrid, anyAttribute, endtagrequired);
    }

    private void handleFunctionStart(Attributes attributes) {
        byte creator = 0;
        String name = "";
        String returns = "";
        for (int x = 0; x < attributes.getLength(); ++x) {
            String attrname = attributes.getQName(x).toLowerCase();
            if (attrname.equals("creator")) {
                creator = Byte.parseByte(attributes.getValue(x));
                continue;
            }
            if (attrname.equals("name")) {
                name = attributes.getValue(x);
                continue;
            }
            if (!attrname.equals("returns")) continue;
            returns = attributes.getValue(x);
        }
        if (this.currentitem instanceof Component) {
            this.methoditem = new Function(name, returns, creator);
        } else {
            this.currentitem = new Function(name, returns, creator);
        }
    }

    private void handleParameterStart(Attributes attributes) {
        String name = "";
        String type = "";
        boolean required = false;
        String defaultValue = null;
        String category = "General";
        for (int x = 0; x < attributes.getLength(); ++x) {
            String attrname = attributes.getQName(x).toLowerCase();
            if (attrname.equals("type")) {
                type = attributes.getValue(x);
                continue;
            }
            if (attrname.equals("name")) {
                name = attributes.getValue(x);
                continue;
            }
            if (attrname.equals("required")) {
                required = this.parseBoolean(attributes.getValue(x));
                continue;
            }
            if (attrname.equals("default")) {
                defaultValue = attributes.getValue(x);
                continue;
            }
            if (!attrname.equals("category")) continue;
            category = attributes.getValue(x);
        }
        this.paramItem = new Parameter(name, type, required, defaultValue, category);
    }

    private void handleParameterEnd() {
        if ((this.currentitem instanceof Function || this.currentitem instanceof Tag) && this.paramItem != null) {
            this.currentitem.addParameter(this.paramItem);
        } else if (this.methoditem != null && this.paramItem != null) {
            this.methoditem.addParameter(this.paramItem);
        }
        this.paramItem = null;
    }

    private void handleValueStart(Attributes attributes) {
        String option = attributes.getValue(0);
        if (option != null && this.paramItem != null) {
            this.paramItem.addValue(new Value(option));
        }
    }

    private void handleValueEnd() {
    }

    private void handleComponentStart(Attributes attributes) {
        byte creator = 0;
        String path = "";
        String name = "";
        String framework = "";
        for (int x = 0; x < attributes.getLength(); ++x) {
            String attrname = attributes.getQName(x).toLowerCase();
            if (attrname.equals("creator")) {
                creator = Byte.parseByte(attributes.getValue(x));
                continue;
            }
            if (attrname.equals("path")) {
                path = attributes.getValue(x);
                String[] tmp = path.split("\\.");
                name = tmp[tmp.length - 1];
                continue;
            }
            if (!attrname.equals("framework")) continue;
            framework = attributes.getValue(x);
        }
        this.currentitem = new Component(name, path, framework, creator);
    }

    private void handleScopeStart(Attributes attributes) {
        String type = attributes.getValue(0);
        String scopeVar = attributes.getValue(1);
        if (scopeVar.indexOf(".") > 0) {
            String scope = scopeVar.substring(0, scopeVar.indexOf("."));
            this.dscopes.put(scope, new ScopeVar(type, scope));
        }
        if (this.currentitem instanceof Component) {
            ((Component)this.currentitem).addScope(scopeVar);
            this.dscopeVars.put(scopeVar, this.currentitem);
        } else {
            this.dscopeVars.put(scopeVar, new ScopeVar(type, scopeVar));
        }
    }

    @Override
    public void endElement(String str, String str1, String str2) throws SAXException {
        if ((str2 = str2.toLowerCase()).equals("tag")) {
            if (this.currentitem != null) {
                this.dtags.put(this.currentitem.getName(), (Tag)this.currentitem);
            }
        } else if (str2.equals("function")) {
            if (this.currentitem instanceof Component) {
                ((Component)this.currentitem).addMethod(this.methoditem);
                this.methoditem = null;
            } else if (this.currentitem instanceof Function) {
                this.dfunctions.put(this.currentitem.getName(), (Function)this.currentitem);
            }
        } else if (str2.equals("parameter")) {
            this.handleParameterEnd();
        } else if (str2.equals("value")) {
            this.handleValueEnd();
        } else if (!str2.equals("help")) {
            if (str2.equals("component")) {
                if (this.currentitem instanceof Component) {
                    this.currentitem = null;
                }
            } else if (!str2.equals("scope") && str2.equals("triggers")) {
                this.handleTriggersEnd();
            }
        }
        this.currenttag = "";
    }

    @Override
    public void startPrefixMapping(String str, String str1) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String str) throws SAXException {
    }

    @Override
    public void characters(char[] values, int start, int length) throws SAXException {
        if (this.currenttag.equalsIgnoreCase("help")) {
            StringBuffer resvalue = new StringBuffer();
            for (int x = start; x < start + length; ++x) {
                resvalue.append(values[x]);
            }
            if (this.currentitem != null && this.paramItem == null) {
                if (resvalue.toString().trim().length() > 0) {
                    this.currentitem.setHelp(this.currentitem.getHelp() + " " + resvalue.toString().trim().replace('\t', ' ') + "\n");
                }
            } else if (this.currentitem != null && this.paramItem != null && resvalue.toString().trim().length() > 0) {
                this.paramItem.setHelp(this.paramItem.getHelp() + " " + resvalue.toString().trim().replace('\t', ' ') + "\n");
            }
        }
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] values, int param, int param2) throws SAXException {
    }

    @Override
    public void processingInstruction(String str, String str1) throws SAXException {
    }

    @Override
    public void skippedEntity(String str) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
    }
}

