/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.repackaged.com.squareup.javapoet;

import com.bumptech.glide.repackaged.com.squareup.javapoet.AnnotationSpec;
import com.bumptech.glide.repackaged.com.squareup.javapoet.CodeWriter;
import com.bumptech.glide.repackaged.com.squareup.javapoet.TypeName;
import com.bumptech.glide.repackaged.com.squareup.javapoet.Util;
import java.io.IOException;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.TypeMirror;

public final class TypeVariableName
extends TypeName {
    public final String name;
    public final List<TypeName> bounds;

    private TypeVariableName(String name, List<TypeName> bounds) {
        this(name, bounds, new ArrayList<AnnotationSpec>());
    }

    private TypeVariableName(String name, List<TypeName> bounds, List<AnnotationSpec> annotations) {
        super(annotations);
        this.name = Util.checkNotNull(name, "name == null", new Object[0]);
        this.bounds = bounds;
        for (TypeName bound : this.bounds) {
            Util.checkArgument(!bound.isPrimitive() && bound != VOID, "invalid bound: %s", bound);
        }
    }

    @Override
    public TypeVariableName annotated(List<AnnotationSpec> annotations) {
        return new TypeVariableName(this.name, this.bounds, annotations);
    }

    @Override
    public TypeName withoutAnnotations() {
        return new TypeVariableName(this.name, this.bounds);
    }

    private static TypeVariableName of(String name, List<TypeName> bounds) {
        ArrayList<TypeName> boundsNoObject = new ArrayList<TypeName>(bounds);
        boundsNoObject.remove(OBJECT);
        return new TypeVariableName(name, Collections.unmodifiableList(boundsNoObject));
    }

    @Override
    CodeWriter emit(CodeWriter out) throws IOException {
        return out.emitAndIndent(this.name);
    }

    public static TypeVariableName get(String name) {
        return TypeVariableName.of(name, Collections.emptyList());
    }

    public static TypeVariableName get(javax.lang.model.type.TypeVariable mirror) {
        return TypeVariableName.get((TypeParameterElement)mirror.asElement());
    }

    static TypeVariableName get(javax.lang.model.type.TypeVariable mirror, Map<TypeParameterElement, TypeVariableName> typeVariables) {
        TypeParameterElement element = (TypeParameterElement)mirror.asElement();
        TypeVariableName typeVariableName = typeVariables.get(element);
        if (typeVariableName == null) {
            ArrayList<TypeName> bounds = new ArrayList<TypeName>();
            List<TypeName> visibleBounds = Collections.unmodifiableList(bounds);
            typeVariableName = new TypeVariableName(element.getSimpleName().toString(), visibleBounds);
            typeVariables.put(element, typeVariableName);
            for (TypeMirror typeMirror : element.getBounds()) {
                bounds.add(TypeName.get(typeMirror, typeVariables));
            }
            bounds.remove(OBJECT);
        }
        return typeVariableName;
    }

    public static TypeVariableName get(TypeParameterElement element) {
        String name = element.getSimpleName().toString();
        List<? extends TypeMirror> boundsMirrors = element.getBounds();
        ArrayList<TypeName> boundsTypeNames = new ArrayList<TypeName>();
        for (TypeMirror typeMirror : boundsMirrors) {
            boundsTypeNames.add(TypeName.get(typeMirror));
        }
        return TypeVariableName.of(name, boundsTypeNames);
    }

    static TypeVariableName get(TypeVariable<?> type, Map<Type, TypeVariableName> map) {
        TypeVariableName result = map.get(type);
        if (result == null) {
            ArrayList<TypeName> bounds = new ArrayList<TypeName>();
            List<TypeName> visibleBounds = Collections.unmodifiableList(bounds);
            result = new TypeVariableName(type.getName(), visibleBounds);
            map.put(type, result);
            for (Type bound : type.getBounds()) {
                bounds.add(TypeName.get(bound, map));
            }
            bounds.remove(OBJECT);
        }
        return result;
    }
}

