/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.v3.auth;

import com.github.binarywang.wxpay.v3.auth.Signer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Base64;
import me.chanjar.weixin.common.error.WxRuntimeException;

public class PrivateKeySigner
implements Signer {
    private String certificateSerialNumber;
    private PrivateKey privateKey;

    public PrivateKeySigner(String serialNumber, PrivateKey privateKey) {
        this.certificateSerialNumber = serialNumber;
        this.privateKey = privateKey;
    }

    @Override
    public Signer.SignatureResult sign(byte[] message) {
        try {
            Signature sign = Signature.getInstance("SHA256withRSA");
            sign.initSign(this.privateKey);
            sign.update(message);
            return new Signer.SignatureResult(Base64.getEncoder().encodeToString(sign.sign()), this.certificateSerialNumber);
        }
        catch (NoSuchAlgorithmException e) {
            throw new WxRuntimeException("\u5f53\u524dJava\u73af\u5883\u4e0d\u652f\u6301SHA256withRSA", (Throwable)e);
        }
        catch (SignatureException e) {
            throw new WxRuntimeException("\u7b7e\u540d\u8ba1\u7b97\u5931\u8d25", (Throwable)e);
        }
        catch (InvalidKeyException e) {
            throw new WxRuntimeException("\u65e0\u6548\u7684\u79c1\u94a5", (Throwable)e);
        }
    }
}

