/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.bean.request;

import com.github.binarywang.wxpay.bean.request.BaseWxPayRequest;
import com.github.binarywang.wxpay.config.WxPayConfig;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.util.Arrays;
import java.util.Map;
import me.chanjar.weixin.common.annotation.Required;
import me.chanjar.weixin.common.util.xml.XStreamCDataConverter;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

@XStreamAlias(value="xml")
public class WxPayRefundRequest
extends BaseWxPayRequest {
    private static final long serialVersionUID = 522565152886671848L;
    private static final String[] REFUND_ACCOUNT = new String[]{"REFUND_SOURCE_RECHARGE_FUNDS", "REFUND_SOURCE_UNSETTLED_FUNDS"};
    @XStreamAlias(value="device_info")
    private String deviceInfo;
    @XStreamAlias(value="transaction_id")
    private String transactionId;
    @XStreamAlias(value="out_trade_no")
    private String outTradeNo;
    @Required
    @XStreamAlias(value="out_refund_no")
    private String outRefundNo;
    @Required
    @XStreamAlias(value="total_fee")
    private Integer totalFee;
    @Required
    @XStreamAlias(value="refund_fee")
    private Integer refundFee;
    @XStreamAlias(value="refund_fee_type")
    private String refundFeeType;
    @XStreamAlias(value="op_user_id")
    private String opUserId;
    @XStreamAlias(value="refund_account")
    private String refundAccount;
    @XStreamAlias(value="refund_desc")
    private String refundDesc;
    @XStreamAlias(value="notify_url")
    private String notifyUrl;
    @XStreamAlias(value="detail")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String detail;

    @Override
    public void checkAndSign(WxPayConfig config) throws WxPayException {
        if (StringUtils.isBlank((CharSequence)this.getOpUserId())) {
            this.setOpUserId(config.getMchId());
        }
        super.checkAndSign(config);
    }

    @Override
    protected void checkConstraints() throws WxPayException {
        if (StringUtils.isNotBlank((CharSequence)this.getRefundAccount()) && !ArrayUtils.contains((Object[])REFUND_ACCOUNT, (Object)this.getRefundAccount())) {
            throw new WxPayException(String.format("refund_account\u76ee\u524d\u5fc5\u987b\u4e3a%s\u5176\u4e2d\u4e4b\u4e00,\u5b9e\u9645\u503c\uff1a%s", Arrays.toString(REFUND_ACCOUNT), this.getRefundAccount()));
        }
        if (StringUtils.isBlank((CharSequence)this.getOutTradeNo()) && StringUtils.isBlank((CharSequence)this.getTransactionId())) {
            throw new WxPayException("transaction_id \u548c out_trade_no \u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff0c\u5fc5\u987b\u63d0\u4f9b\u4e00\u4e2a");
        }
    }

    @Override
    protected void storeMap(Map<String, String> map) {
        map.put("device_info", this.deviceInfo);
        map.put("transaction_id", this.transactionId);
        map.put("out_trade_no", this.outTradeNo);
        map.put("out_refund_no", this.outRefundNo);
        map.put("total_fee", this.totalFee.toString());
        map.put("refund_fee", this.refundFee.toString());
        map.put("refund_fee_type", this.refundFeeType);
        map.put("op_user_id", this.opUserId);
        map.put("refund_account", this.refundAccount);
        map.put("refund_desc", this.refundDesc);
        map.put("notify_url", this.notifyUrl);
    }

    public static WxPayRefundRequestBuilder newBuilder() {
        return new WxPayRefundRequestBuilder();
    }

    public String getDeviceInfo() {
        return this.deviceInfo;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public String getOutTradeNo() {
        return this.outTradeNo;
    }

    public String getOutRefundNo() {
        return this.outRefundNo;
    }

    public Integer getTotalFee() {
        return this.totalFee;
    }

    public Integer getRefundFee() {
        return this.refundFee;
    }

    public String getRefundFeeType() {
        return this.refundFeeType;
    }

    public String getOpUserId() {
        return this.opUserId;
    }

    public String getRefundAccount() {
        return this.refundAccount;
    }

    public String getRefundDesc() {
        return this.refundDesc;
    }

    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    public String getDetail() {
        return this.detail;
    }

    public WxPayRefundRequest setDeviceInfo(String deviceInfo) {
        this.deviceInfo = deviceInfo;
        return this;
    }

    public WxPayRefundRequest setTransactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    public WxPayRefundRequest setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
        return this;
    }

    public WxPayRefundRequest setOutRefundNo(String outRefundNo) {
        this.outRefundNo = outRefundNo;
        return this;
    }

    public WxPayRefundRequest setTotalFee(Integer totalFee) {
        this.totalFee = totalFee;
        return this;
    }

    public WxPayRefundRequest setRefundFee(Integer refundFee) {
        this.refundFee = refundFee;
        return this;
    }

    public WxPayRefundRequest setRefundFeeType(String refundFeeType) {
        this.refundFeeType = refundFeeType;
        return this;
    }

    public WxPayRefundRequest setOpUserId(String opUserId) {
        this.opUserId = opUserId;
        return this;
    }

    public WxPayRefundRequest setRefundAccount(String refundAccount) {
        this.refundAccount = refundAccount;
        return this;
    }

    public WxPayRefundRequest setRefundDesc(String refundDesc) {
        this.refundDesc = refundDesc;
        return this;
    }

    public WxPayRefundRequest setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    public WxPayRefundRequest setDetail(String detail) {
        this.detail = detail;
        return this;
    }

    @Override
    public String toString() {
        return "WxPayRefundRequest(deviceInfo=" + this.getDeviceInfo() + ", transactionId=" + this.getTransactionId() + ", outTradeNo=" + this.getOutTradeNo() + ", outRefundNo=" + this.getOutRefundNo() + ", totalFee=" + this.getTotalFee() + ", refundFee=" + this.getRefundFee() + ", refundFeeType=" + this.getRefundFeeType() + ", opUserId=" + this.getOpUserId() + ", refundAccount=" + this.getRefundAccount() + ", refundDesc=" + this.getRefundDesc() + ", notifyUrl=" + this.getNotifyUrl() + ", detail=" + this.getDetail() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxPayRefundRequest)) {
            return false;
        }
        WxPayRefundRequest other = (WxPayRefundRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$deviceInfo = this.getDeviceInfo();
        String other$deviceInfo = other.getDeviceInfo();
        if (this$deviceInfo == null ? other$deviceInfo != null : !this$deviceInfo.equals(other$deviceInfo)) {
            return false;
        }
        String this$transactionId = this.getTransactionId();
        String other$transactionId = other.getTransactionId();
        if (this$transactionId == null ? other$transactionId != null : !this$transactionId.equals(other$transactionId)) {
            return false;
        }
        String this$outTradeNo = this.getOutTradeNo();
        String other$outTradeNo = other.getOutTradeNo();
        if (this$outTradeNo == null ? other$outTradeNo != null : !this$outTradeNo.equals(other$outTradeNo)) {
            return false;
        }
        String this$outRefundNo = this.getOutRefundNo();
        String other$outRefundNo = other.getOutRefundNo();
        if (this$outRefundNo == null ? other$outRefundNo != null : !this$outRefundNo.equals(other$outRefundNo)) {
            return false;
        }
        Integer this$totalFee = this.getTotalFee();
        Integer other$totalFee = other.getTotalFee();
        if (this$totalFee == null ? other$totalFee != null : !((Object)this$totalFee).equals(other$totalFee)) {
            return false;
        }
        Integer this$refundFee = this.getRefundFee();
        Integer other$refundFee = other.getRefundFee();
        if (this$refundFee == null ? other$refundFee != null : !((Object)this$refundFee).equals(other$refundFee)) {
            return false;
        }
        String this$refundFeeType = this.getRefundFeeType();
        String other$refundFeeType = other.getRefundFeeType();
        if (this$refundFeeType == null ? other$refundFeeType != null : !this$refundFeeType.equals(other$refundFeeType)) {
            return false;
        }
        String this$opUserId = this.getOpUserId();
        String other$opUserId = other.getOpUserId();
        if (this$opUserId == null ? other$opUserId != null : !this$opUserId.equals(other$opUserId)) {
            return false;
        }
        String this$refundAccount = this.getRefundAccount();
        String other$refundAccount = other.getRefundAccount();
        if (this$refundAccount == null ? other$refundAccount != null : !this$refundAccount.equals(other$refundAccount)) {
            return false;
        }
        String this$refundDesc = this.getRefundDesc();
        String other$refundDesc = other.getRefundDesc();
        if (this$refundDesc == null ? other$refundDesc != null : !this$refundDesc.equals(other$refundDesc)) {
            return false;
        }
        String this$notifyUrl = this.getNotifyUrl();
        String other$notifyUrl = other.getNotifyUrl();
        if (this$notifyUrl == null ? other$notifyUrl != null : !this$notifyUrl.equals(other$notifyUrl)) {
            return false;
        }
        String this$detail = this.getDetail();
        String other$detail = other.getDetail();
        return !(this$detail == null ? other$detail != null : !this$detail.equals(other$detail));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof WxPayRefundRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $deviceInfo = this.getDeviceInfo();
        result = result * 59 + ($deviceInfo == null ? 43 : $deviceInfo.hashCode());
        String $transactionId = this.getTransactionId();
        result = result * 59 + ($transactionId == null ? 43 : $transactionId.hashCode());
        String $outTradeNo = this.getOutTradeNo();
        result = result * 59 + ($outTradeNo == null ? 43 : $outTradeNo.hashCode());
        String $outRefundNo = this.getOutRefundNo();
        result = result * 59 + ($outRefundNo == null ? 43 : $outRefundNo.hashCode());
        Integer $totalFee = this.getTotalFee();
        result = result * 59 + ($totalFee == null ? 43 : ((Object)$totalFee).hashCode());
        Integer $refundFee = this.getRefundFee();
        result = result * 59 + ($refundFee == null ? 43 : ((Object)$refundFee).hashCode());
        String $refundFeeType = this.getRefundFeeType();
        result = result * 59 + ($refundFeeType == null ? 43 : $refundFeeType.hashCode());
        String $opUserId = this.getOpUserId();
        result = result * 59 + ($opUserId == null ? 43 : $opUserId.hashCode());
        String $refundAccount = this.getRefundAccount();
        result = result * 59 + ($refundAccount == null ? 43 : $refundAccount.hashCode());
        String $refundDesc = this.getRefundDesc();
        result = result * 59 + ($refundDesc == null ? 43 : $refundDesc.hashCode());
        String $notifyUrl = this.getNotifyUrl();
        result = result * 59 + ($notifyUrl == null ? 43 : $notifyUrl.hashCode());
        String $detail = this.getDetail();
        result = result * 59 + ($detail == null ? 43 : $detail.hashCode());
        return result;
    }

    public WxPayRefundRequest() {
    }

    public WxPayRefundRequest(String deviceInfo, String transactionId, String outTradeNo, String outRefundNo, Integer totalFee, Integer refundFee, String refundFeeType, String opUserId, String refundAccount, String refundDesc, String notifyUrl, String detail) {
        this.deviceInfo = deviceInfo;
        this.transactionId = transactionId;
        this.outTradeNo = outTradeNo;
        this.outRefundNo = outRefundNo;
        this.totalFee = totalFee;
        this.refundFee = refundFee;
        this.refundFeeType = refundFeeType;
        this.opUserId = opUserId;
        this.refundAccount = refundAccount;
        this.refundDesc = refundDesc;
        this.notifyUrl = notifyUrl;
        this.detail = detail;
    }

    public static class WxPayRefundRequestBuilder {
        private String deviceInfo;
        private String transactionId;
        private String outTradeNo;
        private String outRefundNo;
        private Integer totalFee;
        private Integer refundFee;
        private String refundFeeType;
        private String opUserId;
        private String refundAccount;
        private String refundDesc;
        private String notifyUrl;
        private String detail;

        WxPayRefundRequestBuilder() {
        }

        public WxPayRefundRequestBuilder deviceInfo(String deviceInfo) {
            this.deviceInfo = deviceInfo;
            return this;
        }

        public WxPayRefundRequestBuilder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public WxPayRefundRequestBuilder outTradeNo(String outTradeNo) {
            this.outTradeNo = outTradeNo;
            return this;
        }

        public WxPayRefundRequestBuilder outRefundNo(String outRefundNo) {
            this.outRefundNo = outRefundNo;
            return this;
        }

        public WxPayRefundRequestBuilder totalFee(Integer totalFee) {
            this.totalFee = totalFee;
            return this;
        }

        public WxPayRefundRequestBuilder refundFee(Integer refundFee) {
            this.refundFee = refundFee;
            return this;
        }

        public WxPayRefundRequestBuilder refundFeeType(String refundFeeType) {
            this.refundFeeType = refundFeeType;
            return this;
        }

        public WxPayRefundRequestBuilder opUserId(String opUserId) {
            this.opUserId = opUserId;
            return this;
        }

        public WxPayRefundRequestBuilder refundAccount(String refundAccount) {
            this.refundAccount = refundAccount;
            return this;
        }

        public WxPayRefundRequestBuilder refundDesc(String refundDesc) {
            this.refundDesc = refundDesc;
            return this;
        }

        public WxPayRefundRequestBuilder notifyUrl(String notifyUrl) {
            this.notifyUrl = notifyUrl;
            return this;
        }

        public WxPayRefundRequestBuilder detail(String detail) {
            this.detail = detail;
            return this;
        }

        public WxPayRefundRequest build() {
            return new WxPayRefundRequest(this.deviceInfo, this.transactionId, this.outTradeNo, this.outRefundNo, this.totalFee, this.refundFee, this.refundFeeType, this.opUserId, this.refundAccount, this.refundDesc, this.notifyUrl, this.detail);
        }

        public String toString() {
            return "WxPayRefundRequest.WxPayRefundRequestBuilder(deviceInfo=" + this.deviceInfo + ", transactionId=" + this.transactionId + ", outTradeNo=" + this.outTradeNo + ", outRefundNo=" + this.outRefundNo + ", totalFee=" + this.totalFee + ", refundFee=" + this.refundFee + ", refundFeeType=" + this.refundFeeType + ", opUserId=" + this.opUserId + ", refundAccount=" + this.refundAccount + ", refundDesc=" + this.refundDesc + ", notifyUrl=" + this.notifyUrl + ", detail=" + this.detail + ")";
        }
    }
}

