/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.freakchicken.dbapi.plugin;

import com.alibaba.fastjson.JSONObject;
import com.gitee.freakchicken.dbapi.plugin.AlarmPlugin;
import com.gitee.freakchicken.dbapi.plugin.CachePlugin;
import com.gitee.freakchicken.dbapi.plugin.TransformPlugin;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginManager {
    private static final Logger log = LoggerFactory.getLogger(PluginManager.class);
    private static Map<String, CachePlugin> cachePlugins = new ConcurrentHashMap<String, CachePlugin>();
    private static Map<String, TransformPlugin> transformPlugins = new ConcurrentHashMap<String, TransformPlugin>();
    private static Map<String, AlarmPlugin> alarmPlugins = new ConcurrentHashMap<String, AlarmPlugin>();

    public static void loadPlugins() {
        ServiceLoader<CachePlugin> serviceLoader = ServiceLoader.load(CachePlugin.class);
        for (CachePlugin plugin : serviceLoader) {
            plugin.init();
            log.info("{} registered", (Object)plugin.getClass().getName());
            cachePlugins.put(plugin.getClass().getName(), plugin);
        }
        log.info("scan cache plugin finish");
        ServiceLoader<TransformPlugin> serviceLoader2 = ServiceLoader.load(TransformPlugin.class);
        for (TransformPlugin plugin : serviceLoader2) {
            plugin.init();
            log.info("{} registered", (Object)plugin.getClass().getName());
            transformPlugins.put(plugin.getClass().getName(), plugin);
        }
        log.info("scan transform plugin finish");
        ServiceLoader<AlarmPlugin> serviceLoader3 = ServiceLoader.load(AlarmPlugin.class);
        for (AlarmPlugin plugin : serviceLoader3) {
            plugin.init();
            log.info("{} registered", (Object)plugin.getClass().getName());
            alarmPlugins.put(plugin.getClass().getName(), plugin);
        }
        log.info("scan alarm plugin finish");
    }

    public static CachePlugin getCachePlugin(String className) {
        if (!cachePlugins.containsKey(className)) {
            throw new RuntimeException("Plugin not found: " + className);
        }
        return cachePlugins.get(className);
    }

    public static TransformPlugin getTransformPlugin(String className) {
        if (!transformPlugins.containsKey(className)) {
            throw new RuntimeException("Plugin not found: " + className);
        }
        return transformPlugins.get(className);
    }

    public static AlarmPlugin getAlarmPlugin(String className) {
        if (!alarmPlugins.containsKey(className)) {
            throw new RuntimeException("Plugin not found: " + className);
        }
        return alarmPlugins.get(className);
    }

    public static List<JSONObject> getAllCachePlugin() {
        List<JSONObject> collect = cachePlugins.values().stream().map(t -> {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("className", (Object)t.getClass().getName());
            jsonObject.put("name", (Object)t.getName());
            jsonObject.put("description", (Object)t.getDescription());
            jsonObject.put("paramDescription", (Object)t.getParamDescription());
            return jsonObject;
        }).collect(Collectors.toList());
        return collect;
    }

    public static List<JSONObject> getAllTransformPlugin() {
        List<JSONObject> collect = transformPlugins.values().stream().map(t -> {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("className", (Object)t.getClass().getName());
            jsonObject.put("name", (Object)t.getName());
            jsonObject.put("description", (Object)t.getDescription());
            jsonObject.put("paramDescription", (Object)t.getParamDescription());
            return jsonObject;
        }).collect(Collectors.toList());
        return collect;
    }

    public static List<JSONObject> getAllAlarmPlugin() {
        List<JSONObject> collect = alarmPlugins.values().stream().map(t -> {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("className", (Object)t.getClass().getName());
            jsonObject.put("name", (Object)t.getName());
            jsonObject.put("description", (Object)t.getDescription());
            jsonObject.put("paramDescription", (Object)t.getParamDescription());
            return jsonObject;
        }).collect(Collectors.toList());
        return collect;
    }
}

