/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.type;

import com.facebook.presto.spi.type.DateTimeEncoding;
import com.facebook.presto.spi.type.TimeZoneIndex;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.fasterxml.jackson.annotation.JsonValue;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import java.util.TimeZone;

public final class SqlTimeWithTimeZone {
    private final long millisUtc;
    private final TimeZoneKey timeZoneKey;

    public SqlTimeWithTimeZone(long timeWithTimeZone) {
        this.millisUtc = DateTimeEncoding.unpackMillisUtc(timeWithTimeZone);
        this.timeZoneKey = DateTimeEncoding.unpackZoneKey(timeWithTimeZone);
    }

    public SqlTimeWithTimeZone(long millisUtc, TimeZoneKey timeZoneKey) {
        this.millisUtc = millisUtc;
        this.timeZoneKey = timeZoneKey;
    }

    public SqlTimeWithTimeZone(long millisUtc, TimeZone timeZone) {
        this.millisUtc = millisUtc;
        this.timeZoneKey = TimeZoneKey.getTimeZoneKey(timeZone.getID());
    }

    public long getMillisUtc() {
        return this.millisUtc;
    }

    public TimeZoneKey getTimeZoneKey() {
        return this.timeZoneKey;
    }

    public int hashCode() {
        return Objects.hash(this.millisUtc, this.timeZoneKey);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SqlTimeWithTimeZone other = (SqlTimeWithTimeZone)obj;
        return Objects.equals(this.millisUtc, other.millisUtc) && Objects.equals(this.timeZoneKey, other.timeZoneKey);
    }

    @JsonValue
    public String toString() {
        SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss.SSS");
        format.setTimeZone(TimeZoneIndex.getTimeZoneForKey(this.timeZoneKey));
        return format.format(new Date(this.millisUtc)) + " " + this.timeZoneKey.getId();
    }
}

