/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.classloader;

import com.facebook.presto.spi.ConnectorOutputHandleResolver;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.classloader.ThreadContextClassLoader;
import java.util.Objects;

public class ClassLoaderSafeConnectorOutputHandleResolver
implements ConnectorOutputHandleResolver {
    private final ConnectorOutputHandleResolver delegate;
    private final ClassLoader classLoader;

    public ClassLoaderSafeConnectorOutputHandleResolver(ConnectorOutputHandleResolver delegate, ClassLoader classLoader) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    @Override
    public boolean canHandle(ConnectorOutputTableHandle tableHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            boolean bl = this.delegate.canHandle(tableHandle);
            return bl;
        }
    }

    @Override
    public Class<? extends ConnectorOutputTableHandle> getOutputTableHandleClass() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Class<? extends ConnectorOutputTableHandle> clazz = this.delegate.getOutputTableHandleClass();
            return clazz;
        }
    }
}

