/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.block;

import com.facebook.presto.spi.block.AbstractFixedWidthBlock;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.FixedWidthBlock;
import com.facebook.presto.spi.type.FixedWidthType;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import java.util.Arrays;

public class FixedWidthBlockBuilder
extends AbstractFixedWidthBlock
implements BlockBuilder {
    private final BlockBuilderStatus blockBuilderStatus;
    private final SliceOutput sliceOutput;
    private boolean[] valueIsNull;
    private int positionCount;

    public FixedWidthBlockBuilder(FixedWidthType type, BlockBuilderStatus blockBuilderStatus) {
        super(type);
        this.blockBuilderStatus = blockBuilderStatus;
        this.sliceOutput = new DynamicSliceOutput(blockBuilderStatus.getMaxBlockSizeInBytes());
        this.valueIsNull = new boolean[1024];
    }

    public FixedWidthBlockBuilder(FixedWidthType type, int positionCount) {
        super(type);
        Slice slice = Slices.allocate((int)(this.entrySize * positionCount));
        this.blockBuilderStatus = new BlockBuilderStatus(slice.length(), slice.length());
        this.sliceOutput = slice.getOutput();
        this.valueIsNull = new boolean[positionCount];
    }

    @Override
    protected Slice getRawSlice() {
        return this.sliceOutput.getUnderlyingSlice();
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public boolean isEmpty() {
        return this.positionCount == 0;
    }

    @Override
    public boolean isFull() {
        return this.blockBuilderStatus.isFull();
    }

    @Override
    public int getSizeInBytes() {
        long size = (long)this.getRawSlice().length() + SizeOf.sizeOf((boolean[])this.valueIsNull);
        if (size > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)size;
    }

    @Override
    public BlockBuilder appendBoolean(boolean value) {
        this.type.writeBoolean(this.sliceOutput, value);
        this.entryAdded(false);
        return this;
    }

    @Override
    public BlockBuilder appendLong(long value) {
        this.type.writeLong(this.sliceOutput, value);
        this.entryAdded(false);
        return this;
    }

    @Override
    public BlockBuilder appendDouble(double value) {
        this.type.writeDouble(this.sliceOutput, value);
        this.entryAdded(false);
        return this;
    }

    @Override
    public BlockBuilder appendSlice(Slice value) {
        return this.appendSlice(value, 0, value.length());
    }

    @Override
    public BlockBuilder appendSlice(Slice value, int offset, int length) {
        if (length != this.type.getFixedSize()) {
            throw new IllegalArgumentException("length must be " + this.type.getFixedSize() + " but is " + length);
        }
        this.type.writeSlice(this.sliceOutput, value, offset);
        this.entryAdded(false);
        return this;
    }

    @Override
    public BlockBuilder appendNull() {
        this.sliceOutput.writeZero(this.type.getFixedSize());
        this.entryAdded(true);
        return this;
    }

    private void entryAdded(boolean isNull) {
        if (this.positionCount == this.valueIsNull.length - 1) {
            this.valueIsNull = Arrays.copyOf(this.valueIsNull, this.valueIsNull.length * 2);
        }
        this.valueIsNull[this.positionCount] = isNull;
        ++this.positionCount;
        this.blockBuilderStatus.addBytes(this.entrySize);
        if (this.sliceOutput.size() >= this.blockBuilderStatus.getMaxBlockSizeInBytes()) {
            this.blockBuilderStatus.setFull();
        }
    }

    @Override
    protected boolean isEntryNull(int position) {
        return this.valueIsNull[position];
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        int positionCount = this.getPositionCount();
        if (positionOffset < 0 || length < 0 || positionOffset + length > positionCount) {
            throw new IndexOutOfBoundsException("Invalid position " + positionOffset + " in block with " + positionCount + " positions");
        }
        Slice newSlice = this.sliceOutput.slice().slice(positionOffset * this.entrySize, length * this.entrySize);
        boolean[] newValueIsNull = Arrays.copyOfRange(this.valueIsNull, positionOffset, positionOffset + length);
        return new FixedWidthBlock(this.type, length, newSlice, newValueIsNull);
    }

    @Override
    public Block build() {
        return new FixedWidthBlock(this.type, this.positionCount, this.sliceOutput.slice(), this.valueIsNull);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FixedWidthBlockBuilder{");
        sb.append("positionCount=").append(this.positionCount);
        sb.append(", size=").append(this.sliceOutput.size());
        sb.append(", type=").append(this.type);
        sb.append('}');
        return sb.toString();
    }
}

