/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.gamingservices;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Bundle;
import com.facebook.AccessToken;
import com.facebook.FacebookCallback;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.GraphResponse;
import com.facebook.gamingservices.cloudgaming.CloudGameLoginHandler;
import com.facebook.gamingservices.cloudgaming.DaemonRequest;
import com.facebook.gamingservices.cloudgaming.internal.SDKMessageEnum;
import com.facebook.internal.AppCall;
import com.facebook.internal.CallbackManagerImpl;
import com.facebook.internal.CustomTabUtils;
import com.facebook.internal.DialogPresenter;
import com.facebook.internal.FacebookDialogBase;
import com.facebook.internal.FragmentWrapper;
import com.facebook.internal.NativeProtocol;
import com.facebook.internal.Validate;
import com.facebook.share.internal.GameRequestValidation;
import com.facebook.share.internal.ResultProcessor;
import com.facebook.share.internal.ShareInternalUtility;
import com.facebook.share.internal.WebDialogParameters;
import com.facebook.share.model.GameRequestContent;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GameRequestDialog
extends FacebookDialogBase<GameRequestContent, Result> {
    private FacebookCallback mCallback;
    private static final String GAME_REQUEST_DIALOG = "apprequests";
    private static final int DEFAULT_REQUEST_CODE = CallbackManagerImpl.RequestCodeOffset.GameRequest.toRequestCode();

    public static boolean canShow() {
        return true;
    }

    public static void show(Activity activity, GameRequestContent gameRequestContent) {
        new GameRequestDialog(activity).show(gameRequestContent);
    }

    public static void show(androidx.fragment.app.Fragment fragment, GameRequestContent gameRequestContent) {
        GameRequestDialog.show(new FragmentWrapper(fragment), gameRequestContent);
    }

    public static void show(Fragment fragment, GameRequestContent gameRequestContent) {
        GameRequestDialog.show(new FragmentWrapper(fragment), gameRequestContent);
    }

    private static void show(FragmentWrapper fragmentWrapper, GameRequestContent gameRequestContent) {
        new GameRequestDialog(fragmentWrapper).show(gameRequestContent);
    }

    public GameRequestDialog(Activity activity) {
        super(activity, DEFAULT_REQUEST_CODE);
    }

    public GameRequestDialog(androidx.fragment.app.Fragment fragment) {
        this(new FragmentWrapper(fragment));
    }

    public GameRequestDialog(Fragment fragment) {
        this(new FragmentWrapper(fragment));
    }

    private GameRequestDialog(FragmentWrapper fragmentWrapper) {
        super(fragmentWrapper, DEFAULT_REQUEST_CODE);
    }

    protected void registerCallbackImpl(CallbackManagerImpl callbackManager, final FacebookCallback<Result> callback) {
        this.mCallback = callback;
        final ResultProcessor resultProcessor2 = callback == null ? null : new ResultProcessor(callback){

            public void onSuccess(AppCall appCall, Bundle results) {
                if (results != null) {
                    callback.onSuccess((Object)new Result(results));
                } else {
                    this.onCancel(appCall);
                }
            }
        };
        callbackManager.registerCallback(this.getRequestCode(), new CallbackManagerImpl.Callback(){

            public boolean onActivityResult(int resultCode, Intent data) {
                return ShareInternalUtility.handleActivityResult((int)GameRequestDialog.this.getRequestCode(), (int)resultCode, (Intent)data, (ResultProcessor)resultProcessor2);
            }
        });
    }

    protected AppCall createBaseAppCall() {
        return new AppCall(this.getRequestCode());
    }

    protected List<FacebookDialogBase.ModeHandler> getOrderedModeHandlers() {
        ArrayList<FacebookDialogBase.ModeHandler> handlers = new ArrayList<FacebookDialogBase.ModeHandler>();
        handlers.add(new FacebookAppHandler());
        handlers.add(new ChromeCustomTabHandler());
        handlers.add(new WebHandler());
        return handlers;
    }

    protected void showImpl(GameRequestContent content, Object mode) {
        if (CloudGameLoginHandler.isRunningInCloud()) {
            this.showForCloud(content, mode);
            return;
        }
        super.showImpl((Object)content, mode);
    }

    private void showForCloud(GameRequestContent content, Object mode) {
        block5: {
            Activity context = this.getActivityContext();
            AccessToken currentAccessToken = AccessToken.getCurrentAccessToken();
            if (currentAccessToken == null || currentAccessToken.isExpired()) {
                throw new FacebookException("Attempted to open GameRequestDialog with an invalid access token");
            }
            DaemonRequest.Callback requestCallback = new DaemonRequest.Callback(){

                @Override
                public void onCompleted(GraphResponse response) {
                    if (GameRequestDialog.this.mCallback != null) {
                        if (response.getError() != null) {
                            GameRequestDialog.this.mCallback.onError(new FacebookException(response.getError().getErrorMessage()));
                        } else {
                            GameRequestDialog.this.mCallback.onSuccess((Object)new Result(response));
                        }
                    }
                }
            };
            String app_id = currentAccessToken.getApplicationId();
            String action_type = content.getActionType() != null ? content.getActionType().name() : null;
            JSONObject parameters = new JSONObject();
            JSONArray to = new JSONArray();
            try {
                parameters.put("appID", (Object)app_id);
                parameters.put("actionType", (Object)action_type);
                parameters.put("message", (Object)content.getMessage());
                parameters.put("cta", (Object)content.getCta());
                parameters.put("title", (Object)content.getTitle());
                parameters.put("data", (Object)content.getData());
                parameters.put("options", (Object)content.getFilters());
                if (content.getRecipients() != null) {
                    for (String recipient : content.getRecipients()) {
                        to.put((Object)recipient);
                    }
                }
                parameters.put("to", (Object)to);
                DaemonRequest.executeAsync((Context)context, parameters, requestCallback, SDKMessageEnum.OPEN_GAME_REQUESTS_DIALOG);
            }
            catch (JSONException e) {
                if (this.mCallback == null) break block5;
                this.mCallback.onError(new FacebookException("Couldn't prepare Game Request Dialog"));
            }
        }
    }

    private class FacebookAppHandler
    extends FacebookDialogBase.ModeHandler {
        private FacebookAppHandler() {
            super((FacebookDialogBase)GameRequestDialog.this);
        }

        public boolean canShow(GameRequestContent content, boolean isBestEffort) {
            PackageManager packageManager = GameRequestDialog.this.getActivityContext().getPackageManager();
            Intent intent = new Intent("com.facebook.games.gaming_services.DEEPLINK");
            intent.setType("text/plain");
            boolean fbAppCanShow = intent.resolveActivity(packageManager) != null;
            AccessToken currentToken = AccessToken.getCurrentAccessToken();
            boolean isGamingLoggedIn = currentToken != null && currentToken.getGraphDomain() != null && "gaming".equals(currentToken.getGraphDomain());
            return fbAppCanShow && isGamingLoggedIn;
        }

        public AppCall createAppCall(GameRequestContent content) {
            AppCall appCall = GameRequestDialog.this.createBaseAppCall();
            Intent intent = new Intent("com.facebook.games.gaming_services.DEEPLINK");
            intent.setType("text/plain");
            AccessToken accessToken = AccessToken.getCurrentAccessToken();
            Bundle args = new Bundle();
            args.putString("deeplink", "GAME_REQUESTS");
            if (accessToken != null) {
                args.putString("app_id", accessToken.getApplicationId());
            } else {
                args.putString("app_id", FacebookSdk.getApplicationId());
            }
            String action_type = content.getActionType() != null ? content.getActionType().name() : null;
            args.putString("actionType", action_type);
            args.putString("message", content.getMessage());
            args.putString("title", content.getTitle());
            args.putString("data", content.getData());
            args.putString("cta", content.getCta());
            List recipients = content.getRecipients();
            JSONArray to = new JSONArray();
            if (content.getRecipients() != null) {
                for (String recipient : content.getRecipients()) {
                    to.put((Object)recipient);
                }
            }
            args.putString("to", to.toString());
            NativeProtocol.setupProtocolRequestIntent((Intent)intent, (String)appCall.getCallId().toString(), (String)"", (int)NativeProtocol.getLatestKnownVersion(), (Bundle)args);
            appCall.setRequestIntent(intent);
            return appCall;
        }
    }

    private class WebHandler
    extends FacebookDialogBase.ModeHandler {
        private WebHandler() {
            super((FacebookDialogBase)GameRequestDialog.this);
        }

        public boolean canShow(GameRequestContent content, boolean isBestEffort) {
            return true;
        }

        public AppCall createAppCall(GameRequestContent content) {
            GameRequestValidation.validate((GameRequestContent)content);
            AppCall appCall = GameRequestDialog.this.createBaseAppCall();
            DialogPresenter.setupAppCallForWebDialog((AppCall)appCall, (String)GameRequestDialog.GAME_REQUEST_DIALOG, (Bundle)WebDialogParameters.create((GameRequestContent)content));
            return appCall;
        }
    }

    private class ChromeCustomTabHandler
    extends FacebookDialogBase.ModeHandler {
        private ChromeCustomTabHandler() {
            super((FacebookDialogBase)GameRequestDialog.this);
        }

        public boolean canShow(GameRequestContent content, boolean isBestEffort) {
            String chromePackage = CustomTabUtils.getChromePackage();
            return chromePackage != null && Validate.hasCustomTabRedirectActivity((Context)GameRequestDialog.this.getActivityContext(), (String)CustomTabUtils.getDefaultRedirectURI());
        }

        public AppCall createAppCall(GameRequestContent content) {
            GameRequestValidation.validate((GameRequestContent)content);
            AppCall appCall = GameRequestDialog.this.createBaseAppCall();
            Bundle params = WebDialogParameters.create((GameRequestContent)content);
            AccessToken accessToken = AccessToken.getCurrentAccessToken();
            if (accessToken != null) {
                params.putString("app_id", accessToken.getApplicationId());
            } else {
                String applicationId = FacebookSdk.getApplicationId();
                params.putString("app_id", applicationId);
            }
            params.putString("redirect_uri", CustomTabUtils.getDefaultRedirectURI());
            DialogPresenter.setupAppCallForCustomTabDialog((AppCall)appCall, (String)GameRequestDialog.GAME_REQUEST_DIALOG, (Bundle)params);
            return appCall;
        }
    }

    public static final class Result {
        String requestId;
        List<String> to;

        private Result(Bundle results) {
            this.requestId = results.getString("request");
            this.to = new ArrayList<String>();
            while (results.containsKey(String.format("to[%d]", this.to.size()))) {
                this.to.add(results.getString(String.format("to[%d]", this.to.size())));
            }
        }

        private Result(GraphResponse response) {
            try {
                JSONObject data = response.getJSONObject();
                JSONObject nestedData = data.optJSONObject("data");
                if (nestedData != null) {
                    data = nestedData;
                }
                this.requestId = data.getString("request_id");
                this.to = new ArrayList<String>();
                JSONArray recipients = data.getJSONArray("to");
                for (int i = 0; i < recipients.length(); ++i) {
                    this.to.add(recipients.getString(i));
                }
            }
            catch (JSONException e) {
                this.requestId = null;
                this.to = new ArrayList<String>();
            }
        }

        public String getRequestId() {
            return this.requestId;
        }

        public List<String> getRequestRecipients() {
            return this.to;
        }
    }
}

