/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.gamingservices;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Bundle;
import androidx.annotation.Nullable;
import com.facebook.AccessToken;
import com.facebook.FacebookCallback;
import com.facebook.FacebookException;
import com.facebook.FacebookSdk;
import com.facebook.GraphResponse;
import com.facebook.gamingservices.GamingContext;
import com.facebook.gamingservices.cloudgaming.CloudGameLoginHandler;
import com.facebook.gamingservices.cloudgaming.DaemonRequest;
import com.facebook.gamingservices.cloudgaming.internal.SDKMessageEnum;
import com.facebook.gamingservices.model.ContextSwitchContent;
import com.facebook.internal.AppCall;
import com.facebook.internal.CallbackManagerImpl;
import com.facebook.internal.DialogPresenter;
import com.facebook.internal.FacebookDialogBase;
import com.facebook.internal.FragmentWrapper;
import com.facebook.internal.NativeProtocol;
import com.facebook.share.internal.ResultProcessor;
import com.facebook.share.internal.ShareInternalUtility;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class ContextSwitchDialog
extends FacebookDialogBase<ContextSwitchContent, Result> {
    private static final int DEFAULT_REQUEST_CODE = CallbackManagerImpl.RequestCodeOffset.GamingContextSwitch.toRequestCode();
    @Nullable
    private FacebookCallback mCallback;

    public ContextSwitchDialog(Activity activity) {
        super(activity, DEFAULT_REQUEST_CODE);
    }

    public ContextSwitchDialog(androidx.fragment.app.Fragment fragment) {
        this(new FragmentWrapper(fragment));
    }

    public ContextSwitchDialog(Fragment fragment) {
        this(new FragmentWrapper(fragment));
    }

    private ContextSwitchDialog(FragmentWrapper fragmentWrapper) {
        super(fragmentWrapper, DEFAULT_REQUEST_CODE);
    }

    public boolean canShow(ContextSwitchContent content) {
        if (CloudGameLoginHandler.isRunningInCloud()) {
            return true;
        }
        return new FacebookAppHandler().canShow(content, true) || new WebHandler().canShow(content, true);
    }

    protected void showImpl(ContextSwitchContent content, Object mode) {
        if (CloudGameLoginHandler.isRunningInCloud()) {
            this.showForCloud(content, mode);
            return;
        }
        super.showImpl((Object)content, mode);
    }

    private void showForCloud(ContextSwitchContent content, Object mode) {
        block5: {
            Activity context = this.getActivityContext();
            AccessToken currentAccessToken = AccessToken.getCurrentAccessToken();
            if (currentAccessToken == null || currentAccessToken.isExpired()) {
                throw new FacebookException("Attempted to open ContextSwitchContent with an invalid access token");
            }
            DaemonRequest.Callback requestCallback = new DaemonRequest.Callback(){

                @Override
                public void onCompleted(GraphResponse response) {
                    if (ContextSwitchDialog.this.mCallback != null) {
                        if (response.getError() != null) {
                            ContextSwitchDialog.this.mCallback.onError(new FacebookException(response.getError().getErrorMessage()));
                        } else {
                            ContextSwitchDialog.this.mCallback.onSuccess((Object)new Result(response));
                        }
                    }
                }
            };
            String contextID = content.getContextID();
            if (contextID == null) {
                if (this.mCallback != null) {
                    this.mCallback.onError(new FacebookException("Required string contextID not provided."));
                }
                return;
            }
            JSONObject parameters = new JSONObject();
            try {
                parameters.put("id", (Object)contextID);
                DaemonRequest.executeAsync((Context)context, parameters, requestCallback, SDKMessageEnum.CONTEXT_SWITCH);
            }
            catch (JSONException e) {
                if (this.mCallback == null) break block5;
                this.mCallback.onError(new FacebookException("Couldn't prepare Context Switch Dialog"));
            }
        }
    }

    protected void registerCallbackImpl(CallbackManagerImpl callbackManager, final FacebookCallback callback) {
        this.mCallback = callback;
        final ResultProcessor resultProcessor2 = callback == null ? null : new ResultProcessor(callback){

            public void onSuccess(AppCall appCall, Bundle results) {
                if (results != null) {
                    if (results.getString("error_message") != null) {
                        callback.onError(new FacebookException(results.getString("error_message")));
                        return;
                    }
                    if (results.getString("id") != null) {
                        GamingContext.setCurrentGamingContext(new GamingContext(results.getString("id")));
                        callback.onSuccess((Object)new Result(results.getString("id")));
                    } else if (results.getString("context_id") != null) {
                        GamingContext.setCurrentGamingContext(new GamingContext(results.getString("context_id")));
                        callback.onSuccess((Object)new Result(results.getString("context_id")));
                    }
                    callback.onError(new FacebookException(results.getString("Invalid response received from server.")));
                } else {
                    this.onCancel(appCall);
                }
            }
        };
        callbackManager.registerCallback(this.getRequestCode(), new CallbackManagerImpl.Callback(){

            public boolean onActivityResult(int resultCode, Intent data) {
                return ShareInternalUtility.handleActivityResult((int)ContextSwitchDialog.this.getRequestCode(), (int)resultCode, (Intent)data, (ResultProcessor)resultProcessor2);
            }
        });
    }

    protected List<FacebookDialogBase.ModeHandler> getOrderedModeHandlers() {
        ArrayList<FacebookDialogBase.ModeHandler> handlers = new ArrayList<FacebookDialogBase.ModeHandler>();
        handlers.add(new FacebookAppHandler());
        handlers.add(new WebHandler());
        return handlers;
    }

    protected AppCall createBaseAppCall() {
        return new AppCall(this.getRequestCode());
    }

    private class FacebookAppHandler
    extends FacebookDialogBase.ModeHandler {
        private FacebookAppHandler() {
            super((FacebookDialogBase)ContextSwitchDialog.this);
        }

        public boolean canShow(ContextSwitchContent content, boolean isBestEffort) {
            PackageManager packageManager = ContextSwitchDialog.this.getActivityContext().getPackageManager();
            Intent intent = new Intent("com.facebook.games.gaming_services.DEEPLINK");
            intent.setType("text/plain");
            boolean fbAppCanShow = intent.resolveActivity(packageManager) != null;
            AccessToken currentToken = AccessToken.getCurrentAccessToken();
            boolean isGamingLoggedIn = currentToken != null && currentToken.getGraphDomain() != null && "gaming".equals(currentToken.getGraphDomain());
            return fbAppCanShow && isGamingLoggedIn;
        }

        public AppCall createAppCall(ContextSwitchContent content) {
            AppCall appCall = ContextSwitchDialog.this.createBaseAppCall();
            Intent intent = new Intent("com.facebook.games.gaming_services.DEEPLINK");
            intent.setType("text/plain");
            AccessToken accessToken = AccessToken.getCurrentAccessToken();
            Bundle args = new Bundle();
            args.putString("deeplink", "CONTEXT_SWITCH");
            if (accessToken != null) {
                args.putString("game_id", accessToken.getApplicationId());
            } else {
                args.putString("game_id", FacebookSdk.getApplicationId());
            }
            if (content.getContextID() != null) {
                args.putString("context_token_id", content.getContextID());
            }
            NativeProtocol.setupProtocolRequestIntent((Intent)intent, (String)appCall.getCallId().toString(), (String)"", (int)NativeProtocol.getLatestKnownVersion(), (Bundle)args);
            appCall.setRequestIntent(intent);
            return appCall;
        }
    }

    private class WebHandler
    extends FacebookDialogBase.ModeHandler {
        private WebHandler() {
            super((FacebookDialogBase)ContextSwitchDialog.this);
        }

        public boolean canShow(ContextSwitchContent content, boolean isBestEffort) {
            return true;
        }

        public AppCall createAppCall(ContextSwitchContent content) {
            AppCall appCall = ContextSwitchDialog.this.createBaseAppCall();
            Bundle webParams = new Bundle();
            webParams.putString("context_id", content.getContextID());
            AccessToken currentToken = AccessToken.getCurrentAccessToken();
            if (currentToken != null) {
                webParams.putString("dialog_access_token", currentToken.getToken());
            }
            DialogPresenter.setupAppCallForWebDialog((AppCall)appCall, (String)"context", (Bundle)webParams);
            return appCall;
        }
    }

    public static final class Result {
        @Nullable
        String contextID;

        private Result(String contextID) {
            this.contextID = contextID;
        }

        private Result(GraphResponse response) {
            try {
                JSONObject data = response.getJSONObject();
                if (data == null) {
                    this.contextID = null;
                    return;
                }
                JSONObject nestedData = data.optJSONObject("data");
                this.contextID = nestedData != null ? nestedData.getString("id") : null;
            }
            catch (JSONException e) {
                this.contextID = null;
            }
        }

        @Nullable
        public String getContextID() {
            return this.contextID;
        }
    }
}

