/*
 * Decompiled with CFR 0.152.
 */
package com.eclecticlogic.pedal.provider.hibernate.dialect;

import com.eclecticlogic.pedal.provider.hibernate.dialect.CopyCapable;
import com.eclecticlogic.pedal.provider.hibernate.dialect.CopyList;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.List;

public class CopyListReader<E extends Serializable>
extends Reader {
    private CopyList<E> copyList;
    private int listIndex;
    private StringBuilder buffer = new StringBuilder(8192);

    public CopyListReader(CopyList<E> copyList) {
        this.copyList = copyList;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.buffer.length() > len) {
            System.arraycopy(this.buffer.toString().toCharArray(), 0, cbuf, off, len);
            this.buffer.replace(0, len, "");
            return len;
        }
        while (this.listIndex < this.copyList.size()) {
            this.buffer.append(this.copyEncode((Serializable)this.copyList.get(this.listIndex++)));
            if (this.buffer.length() <= len) continue;
        }
        if (this.listIndex >= this.copyList.size() && this.buffer.length() == 0) {
            return -1;
        }
        int min = Integer.min(this.buffer.length(), len);
        System.arraycopy(this.buffer.toString().toCharArray(), 0, cbuf, off, min);
        this.buffer.replace(0, min, "");
        return min;
    }

    private String copyEncode(E entity) {
        if (entity instanceof CopyCapable) {
            List<Object> values = ((CopyCapable)entity).getCopyColumnValues();
            StringBuilder builder = new StringBuilder();
            for (Object value : values) {
                builder.append("\t");
                if (value != null) {
                    builder.append(value.toString());
                    continue;
                }
                builder.append("\\N");
            }
            builder.append("\n");
            return builder.substring(1);
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        this.buffer = null;
    }
}

