/*
 * Decompiled with CFR 0.152.
 */
package com.eclecticlogic.pedal.provider.hibernate.dialect;

import com.eclecticlogic.pedal.provider.ConnectionAccessor;
import com.eclecticlogic.pedal.provider.hibernate.dialect.CopyCapable;
import com.eclecticlogic.pedal.provider.hibernate.dialect.CopyList;
import com.eclecticlogic.pedal.provider.hibernate.dialect.CopyListReader;
import com.eclecticlogic.pedal.spi.ProviderAccessSpi;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import javax.persistence.EntityManager;
import org.postgresql.copy.CopyManager;
import org.postgresql.core.BaseConnection;

public class CopyCommand {
    private ConnectionAccessor connectionAccessor;
    private ProviderAccessSpi providerAccessSpi;

    public void setConnectionAccessor(ConnectionAccessor connectionAccessor) {
        this.connectionAccessor = connectionAccessor;
    }

    public void setProviderAccessSpi(ProviderAccessSpi providerAccessSpi) {
        this.providerAccessSpi = providerAccessSpi;
    }

    public <E extends Serializable> void insert(EntityManager entityManager, CopyList<E> ... lists) {
        if (lists != null) {
            this.providerAccessSpi.run(entityManager, connection -> {
                try {
                    CopyManager copyManager = new CopyManager((BaseConnection)this.connectionAccessor.getRawConnection((Connection)connection));
                    for (CopyList copyList : lists) {
                        this._insert(copyManager, copyList);
                    }
                }
                catch (Exception e) {
                    throw Throwables.propagate((Throwable)e);
                }
            });
        }
    }

    private <E extends Serializable> void _insert(CopyManager copyManager, CopyList<E> copyList) throws IOException, SQLException {
        if (copyList.size() != 0) {
            copyManager.copyIn("copy " + this.getEntityName(copyList) + "(" + this.getFieldNames(copyList) + ") from stdin", new CopyListReader<E>(copyList));
        }
    }

    private <E extends Serializable> String getEntityName(CopyList<E> copyList) {
        if (Strings.isNullOrEmpty((String)copyList.getAlternateTableName())) {
            return this.providerAccessSpi.getTableName(((Serializable)copyList.get(0)).getClass());
        }
        String schemaName = this.providerAccessSpi.getSchemaName();
        if (Strings.isNullOrEmpty((String)schemaName)) {
            return copyList.getAlternateTableName();
        }
        return schemaName + "." + copyList.getAlternateTableName();
    }

    private <E extends Serializable> String getFieldNames(CopyList<E> copyList) {
        Serializable entity = (Serializable)copyList.get(0);
        if (entity instanceof CopyCapable) {
            return String.join((CharSequence)", ", ((CopyCapable)((Object)entity)).getCopyColumnNames());
        }
        throw new UnsupportedOperationException();
    }
}

