/*
 * Decompiled with CFR 0.152.
 */
package com.eclecticlogic.pedal.provider.hibernate;

import com.eclecticlogic.pedal.spi.ProviderAccessSpi;
import java.io.Serializable;
import java.sql.Connection;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.jpa.HibernateEntityManagerFactory;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.persister.entity.SingleTableEntityPersister;

public class HibernateProviderAccessSpiImpl
implements ProviderAccessSpi {
    private EntityManagerFactory emf;

    public void setEntityManagerFactory(EntityManagerFactory emf) {
        this.emf = emf;
    }

    @Override
    public String getSchemaName() {
        SessionFactory sf = ((HibernateEntityManagerFactory)this.emf.unwrap(HibernateEntityManagerFactory.class)).getSessionFactory();
        SessionFactoryImplementor sfi = (SessionFactoryImplementor)sf;
        String schema = sfi.getSettings().getDefaultSchemaName();
        return schema == null ? "" : schema;
    }

    @Override
    public String getTableName(Class<? extends Serializable> entityClass) {
        SessionFactory sf = ((HibernateEntityManagerFactory)this.emf.unwrap(HibernateEntityManagerFactory.class)).getSessionFactory();
        ClassMetadata metadata = sf.getClassMetadata(entityClass);
        if (metadata instanceof SingleTableEntityPersister) {
            SingleTableEntityPersister step = (SingleTableEntityPersister)metadata;
            return step.getTableName();
        }
        return null;
    }

    @Override
    public void run(EntityManager entityManager, Consumer<Connection> work) {
        Session session = (Session)entityManager.unwrap(Session.class);
        session.doWork(connection -> work.accept(connection));
    }

    @Override
    public <R> R exec(EntityManager entityManager, Function<Connection, R> work) {
        Session session = (Session)entityManager.unwrap(Session.class);
        return (R)session.doReturningWork(connection -> work.apply(connection));
    }
}

