/*
 * Decompiled with CFR 0.152.
 */
package com.eclecticlogic.pedal.provider.hibernate;

import com.eclecticlogic.pedal.provider.hibernate.AbstractMutableUserType;
import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;

public abstract class ArrayToSetUserType<T>
extends AbstractMutableUserType {
    protected abstract String getDialectPrimitiveName();

    public int[] sqlTypes() {
        return new int[]{2003};
    }

    public Class<?> returnedClass() {
        return Set.class;
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        Array sqlArray = rs.getArray(names[0]);
        if (rs.wasNull()) {
            return Collections.EMPTY_SET;
        }
        HashSet<Object> set = new HashSet<Object>();
        for (Object element : (Object[])sqlArray.getArray()) {
            set.add(element);
        }
        return set;
    }

    public void nullSafeSet(PreparedStatement statement, Object object, int i, SessionImplementor session) throws HibernateException, SQLException {
        Connection connection = session.connection();
        Set set = (Set)object;
        Object[] elements = set == null ? new Object[]{} : set.toArray();
        Array array = connection.createArrayOf(this.getDialectPrimitiveName(), elements);
        statement.setArray(i, array);
    }

    public Object deepCopy(Object value) throws HibernateException {
        if (value == null) {
            return new HashSet();
        }
        return new HashSet((Collection)value);
    }
}

