/*
 * Decompiled with CFR 0.152.
 */
package com.eclecticlogic.pedal.provider.hibernate;

import com.eclecticlogic.pedal.provider.hibernate.AbstractMutableUserType;
import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;

public abstract class ArrayToListUserType<T>
extends AbstractMutableUserType {
    protected abstract String getDialectPrimitiveName();

    public int[] sqlTypes() {
        return new int[]{2003};
    }

    public Class<?> returnedClass() {
        return List.class;
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        Array sqlArray = rs.getArray(names[0]);
        if (rs.wasNull()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object element : (Object[])sqlArray.getArray()) {
            list.add(element);
        }
        return list;
    }

    public void nullSafeSet(PreparedStatement statement, Object object, int i, SessionImplementor session) throws HibernateException, SQLException {
        Connection connection = session.connection();
        List list = (List)object;
        Object[] elements = list == null ? new Object[]{} : list.toArray();
        Array array = connection.createArrayOf(this.getDialectPrimitiveName(), elements);
        statement.setArray(i, array);
    }

    public Object deepCopy(Object value) throws HibernateException {
        if (value == null) {
            return new ArrayList();
        }
        return new ArrayList((Collection)value);
    }
}

