/*
 * Decompiled with CFR 0.152.
 */
package com.eclecticlogic.pedal.impl;

import com.eclecticlogic.pedal.DataContext;
import com.eclecticlogic.pedal.impl.TransactionSynchronizationAdapterData;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class TransactionSynchronizationAdapterTask
extends TransactionSynchronizationAdapter {
    private List<Consumer<DataContext>> preCommit = new ArrayList<Consumer<DataContext>>();
    private List<Consumer<DataContext>> postCommit = new ArrayList<Consumer<DataContext>>();

    static TransactionSynchronizationAdapterTask instance() {
        for (TransactionSynchronization txSync : TransactionSynchronizationManager.getSynchronizations()) {
            if (!(txSync instanceof TransactionSynchronizationAdapterTask)) continue;
            return (TransactionSynchronizationAdapterTask)txSync;
        }
        return null;
    }

    public void addBeforeCommit(Consumer<DataContext> task) {
        this.preCommit.add(task);
    }

    public void addAfterCommit(Consumer<DataContext> task) {
        this.postCommit.add(task);
    }

    public void beforeCommit(boolean readOnly) {
        DataContextImpl data = new DataContextImpl();
        for (Consumer<DataContext> task : this.preCommit) {
            task.accept(data);
        }
    }

    public void afterCommit() {
        DataContextImpl data = new DataContextImpl();
        for (Consumer<DataContext> task : this.postCommit) {
            task.accept(data);
        }
    }

    public class DataContextImpl
    implements DataContext {
        @Override
        public void put(Object key, Object value) {
            TransactionSynchronizationAdapterData.instance().put(key, value);
        }

        @Override
        public <T> T get(Object key) {
            return TransactionSynchronizationAdapterData.instance().get(key);
        }
    }
}

