/*
 * Decompiled with CFR 0.152.
 */
package com.eclecticlogic.pedal.impl;

import com.eclecticlogic.pedal.Context;
import com.eclecticlogic.pedal.Transaction;
import com.eclecticlogic.pedal.TransactionRunner;
import com.eclecticlogic.pedal.impl.ContextImpl;
import java.util.Stack;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class TransactionImpl
implements Transaction {
    private PlatformTransactionManager platformTransactionManager;
    private ThreadLocal<Stack<TransactionDefinition>> localTransactionDefinition = new ThreadLocal<Stack<TransactionDefinition>>(){

        @Override
        protected Stack<TransactionDefinition> initialValue() {
            Stack<TransactionDefinition> stack = new Stack<TransactionDefinition>();
            return stack;
        }
    };
    private static Logger logger = LoggerFactory.getLogger(TransactionImpl.class);

    protected PlatformTransactionManager getPlatformTransactionManager() {
        return this.platformTransactionManager;
    }

    public void setPlatformTransactionManager(PlatformTransactionManager platformTransactionManager) {
        this.platformTransactionManager = platformTransactionManager;
    }

    @Override
    public TransactionRunner with(Propagation propagation) {
        if (propagation == Propagation.NOT_SUPPORTED) {
            throw new IllegalArgumentException(propagation.name());
        }
        DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
        transactionDefinition.setPropagationBehavior(propagation.value());
        this.localTransactionDefinition.get().push((TransactionDefinition)transactionDefinition);
        return this;
    }

    @Override
    public void run(Consumer<Context> block) {
        this._exec(context -> {
            block.accept((Context)context);
            return null;
        });
    }

    @Override
    public void run(Runnable block) {
        this._exec(context -> {
            block.run();
            return null;
        });
    }

    @Override
    public <R> R exec(Supplier<R> block) {
        return (R)this._exec(context -> block.get());
    }

    @Override
    public <R> R exec(Function<Context, R> block) {
        return (R)this._exec(context -> block.apply((Context)context));
    }

    public <R> R _exec(Function<Context, R> runner) {
        TransactionStatus status = null;
        try {
            status = this.getPlatformTransactionManager().getTransaction(this.getTransactionDefinition());
            logger.trace("start: new = {}", (Object)(status.isNewTransaction() ? "yes" : "no"));
            ContextImpl context = new ContextImpl();
            R retval = runner.apply(context);
            if (status.isRollbackOnly()) {
                this.getPlatformTransactionManager().rollback(status);
                logger.trace("rollback");
            } else {
                this.getPlatformTransactionManager().commit(status);
                logger.trace("commit");
            }
            return retval;
        }
        catch (RuntimeException e) {
            if (status != null && !status.isCompleted()) {
                this.getPlatformTransactionManager().rollback(status);
                logger.trace("rollback");
            } else if (!status.isRollbackOnly()) {
                logger.trace("Transaction already complete.");
            }
            throw e;
        }
    }

    private TransactionDefinition getTransactionDefinition() {
        if (this.localTransactionDefinition.get().isEmpty()) {
            DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
            transactionDefinition.setPropagationBehavior(Propagation.REQUIRED.value());
            return transactionDefinition;
        }
        return this.localTransactionDefinition.get().pop();
    }
}

