/*
 * Decompiled with CFR 0.152.
 */
package com.eclecticlogic.pedal.dm.internal;

import com.eclecticlogic.pedal.Transaction;
import com.eclecticlogic.pedal.dm.Select;
import com.eclecticlogic.pedal.dm.internal.AbstractDDL;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import javax.persistence.Query;

public class SelectImpl<E extends Serializable>
extends AbstractDDL<E>
implements Select<E> {
    private int maxResults;
    private int firstResult;

    public SelectImpl(EntityManager entityManager, Transaction transaction) {
        super(entityManager, transaction);
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public int getFirstResult() {
        return this.firstResult;
    }

    @Override
    public Select<E> returning(int maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    @Override
    public Select<E> startingAt(int startPosition) {
        this.firstResult = startPosition;
        return this;
    }

    @Override
    public Select<E> bind(String param, Object value) {
        this.getBindings().add(new AbstractDDL.Binding(param, value));
        return this;
    }

    @Override
    public Select<E> using(LockModeType lock) {
        this.setLockModeType(lock);
        return this;
    }

    @Override
    protected Query getQuery() {
        Query query = super.getQuery();
        if (this.getMaxResults() > 0) {
            query.setMaxResults(this.getMaxResults());
        }
        if (this.getFirstResult() > 0) {
            query.setFirstResult(this.getFirstResult());
        }
        return query;
    }

    @Override
    public List<E> list() {
        Query query = this.getQuery();
        return query.getResultList();
    }

    @Override
    public Optional<E> get() {
        List<E> list = this.list();
        return list.size() == 0 ? Optional.empty() : Optional.of(list.get(0));
    }

    @Override
    public <R> Optional<R> scalar() {
        try {
            Query query = this.getQuery();
            return Optional.ofNullable(query.getSingleResult());
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @Override
    public <R> List<R> scalarList() {
        try {
            Query query = this.getQuery();
            return query.getResultList();
        }
        catch (NoResultException e) {
            return Collections.EMPTY_LIST;
        }
    }
}

