/*
 * Decompiled with CFR 0.152.
 */
package com.eclecticlogic.pedal.dm.internal;

import com.eclecticlogic.pedal.Transaction;
import com.eclecticlogic.pedal.dm.DAO;
import com.eclecticlogic.pedal.dm.DAORegistry;
import com.eclecticlogic.pedal.dm.TestableDAO;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class DAORegistryImpl
implements DAORegistry,
BeanPostProcessor {
    private Transaction transaction;
    private EntityManagerFactory entityManagerFactory;
    private Map<Class<?>, DAO<? extends Serializable, ? extends Serializable>> daosByEntityClass = new HashMap();
    private static Logger logger = LoggerFactory.getLogger(DAORegistryImpl.class);

    protected Transaction getTransaction() {
        return this.transaction;
    }

    public void setTransaction(Transaction transaction) {
        this.transaction = transaction;
    }

    protected EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    public void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof DAO) {
            DAO dao = (DAO)bean;
            this.daosByEntityClass.put(dao.getEntityClass(), dao);
        }
        return bean;
    }

    @Override
    public <E extends Serializable, P extends Serializable> DAO<E, P> get(Class<E> clz) {
        return this.daosByEntityClass.get(clz);
    }

    @Override
    public <E extends Serializable, P extends Serializable> DAO<E, P> get(E entity) {
        return this.daosByEntityClass.get(this.getEntityClass(entity));
    }

    @Override
    public <E extends Serializable, P extends Serializable> void testDAOs() {
        for (DAO<? extends Serializable, ? extends Serializable> udao : this.daosByEntityClass.values()) {
            DAO dao = this.getGenericizedDAO(udao);
            if (!(dao instanceof TestableDAO)) continue;
            logger.debug("Testing DAO " + dao.getClass().getName());
            Object pk = ((TestableDAO)((Object)dao)).getPrototypicalPrimaryKey();
            logger.trace("Testing find method with pk " + pk);
            dao.findById(pk);
        }
    }

    private <E extends Serializable, P extends Serializable> DAO<E, P> getGenericizedDAO(DAO<? extends Serializable, ? extends Serializable> dao) {
        return dao;
    }

    private Class<?> getEntityClass(Object object) {
        Class<?> clz;
        for (clz = object.getClass(); clz != null; clz = clz.getSuperclass()) {
            try {
                this.getEntityManagerFactory().getMetamodel().entity(clz);
                break;
            }
            catch (IllegalArgumentException e) {
                continue;
            }
        }
        return clz;
    }
}

