/*
 * Decompiled with CFR 0.152.
 */
package com.eclecticlogic.pedal.dm.internal;

import com.eclecticlogic.pedal.Transaction;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaQuery;

public class AbstractDDL<E extends Serializable> {
    private EntityManager entityManager;
    private Transaction transaction;
    private QueryType queryType;
    private String queryString;
    private TypedQuery<E> queryTyped;
    private CriteriaQuery<E> queryCriteria;
    private LockModeType lockModeType;
    private List<Binding> bindings = new ArrayList<Binding>();

    protected AbstractDDL(EntityManager entityManager, Transaction transaction) {
        this.entityManager = entityManager;
        this.transaction = transaction;
    }

    protected EntityManager getEntityManager() {
        return this.entityManager;
    }

    protected Transaction getTransaction() {
        return this.transaction;
    }

    protected List<Binding> getBindings() {
        return this.bindings;
    }

    protected void setLockModeType(LockModeType lockModeType) {
        this.lockModeType = lockModeType;
    }

    public void setQuery(String query, boolean nativeQuery) {
        this.queryString = query;
        this.queryType = nativeQuery ? QueryType.NATIVE : QueryType.STRING;
    }

    public void setQuery(String query) {
        this.queryString = query;
        this.queryType = QueryType.STRING;
    }

    public void setQuery(TypedQuery<E> typedQuery) {
        this.queryTyped = typedQuery;
        this.queryType = QueryType.TYPED;
    }

    public void setQuery(CriteriaQuery<E> criteriaQuery) {
        this.queryCriteria = criteriaQuery;
        this.queryType = QueryType.CRITERIA;
    }

    protected Query getQuery() {
        Query q = null;
        switch (this.queryType) {
            case NATIVE: {
                q = this.getEntityManager().createNativeQuery(this.queryString);
                break;
            }
            case STRING: {
                q = this.getEntityManager().createQuery(this.queryString);
                break;
            }
            case TYPED: {
                q = this.queryTyped;
                break;
            }
            case CRITERIA: {
                q = this.getEntityManager().createQuery(this.queryCriteria);
            }
        }
        for (Binding binding : this.bindings) {
            binding.bind(q);
        }
        if (this.lockModeType != null) {
            q.setLockMode(this.lockModeType);
        }
        return q;
    }

    protected class Binding {
        private String name;
        private Object value;

        public Binding(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public void bind(Query q) {
            q.setParameter(this.name, this.value);
        }
    }

    private static enum QueryType {
        NATIVE,
        STRING,
        TYPED,
        CRITERIA;

    }
}

