/*
 * Decompiled with CFR 0.152.
 */
package com.eclecticlogic.pedal.dm;

import com.eclecticlogic.pedal.ProviderAccess;
import com.eclecticlogic.pedal.Transaction;
import com.eclecticlogic.pedal.dm.DAO;
import com.eclecticlogic.pedal.dm.DAOMeta;
import com.eclecticlogic.pedal.dm.Select;
import com.eclecticlogic.pedal.dm.Update;
import com.eclecticlogic.pedal.dm.internal.SelectImpl;
import com.eclecticlogic.pedal.dm.internal.UpdateImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.SingularAttribute;

public abstract class AbstractDAO<E extends Serializable, P extends Serializable>
implements DAO<E, P>,
DAOMeta<E, P> {
    private Transaction transaction;
    private EntityManager entityManager;
    private ProviderAccess providerAccess;

    protected EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    protected Transaction getTransaction() {
        return this.transaction;
    }

    public void setTransaction(Transaction transaction) {
        this.transaction = transaction;
    }

    protected ProviderAccess getProviderAccess() {
        return this.providerAccess;
    }

    public void setProviderAccess(ProviderAccess providerAccess) {
        this.providerAccess = providerAccess;
    }

    protected String getTableName() {
        return this.getProviderAccess().getTableName(this.getEntityClass());
    }

    @Override
    public EntityType<E> getEntityType() {
        return this.getEntityManager().getEntityManagerFactory().getMetamodel().entity(this.getEntityClass());
    }

    @Override
    public E create(E entity) {
        return (E)this.getTransaction().exec(() -> {
            this.getEntityManager().persist((Object)entity);
            return entity;
        });
    }

    @Override
    public List<E> create(E ... entities) {
        return this.getTransaction().exec(() -> {
            ArrayList<Serializable> list = new ArrayList<Serializable>();
            for (Serializable e : entities) {
                list.add(this.create((E)e));
            }
            return list;
        });
    }

    @Override
    public Optional<E> findById(P id) {
        return this.getTransaction().exec(() -> Optional.ofNullable(this.getEntityManager().find(this.getEntityClass(), (Object)id)));
    }

    @Override
    public List<E> findById(P ... ids) {
        return this.getTransaction().exec(context -> {
            CriteriaBuilder builder = this.getEntityManager().getCriteriaBuilder();
            CriteriaQuery cq = builder.createQuery(this.getEntityClass());
            Root root = cq.from(this.getEntityClass());
            cq.select((Selection)root).where((Expression)builder.in((Expression)root.get(this.getIdProperty())).in((Object[])ids));
            TypedQuery query = this.getEntityManager().createQuery(cq);
            return query.getResultList();
        });
    }

    protected String getIdProperty() {
        for (SingularAttribute attr : this.getEntityType().getSingularAttributes()) {
            if (!attr.isId()) continue;
            return attr.getName();
        }
        return null;
    }

    @Override
    public E update(E entity) {
        return (E)this.getTransaction().exec(() -> {
            Serializable t = (Serializable)this.getEntityManager().merge((Object)entity);
            this.getEntityManager().persist((Object)t);
            return t;
        });
    }

    @Override
    public List<E> update(E ... entities) {
        return this.getTransaction().exec(() -> {
            ArrayList<Serializable> list = new ArrayList<Serializable>();
            for (Serializable e : entities) {
                list.add(this.update((E)e));
            }
            return list;
        });
    }

    @Override
    public E delete(E entity) {
        return (E)this.getTransaction().exec(() -> {
            Serializable mergedObject = (Serializable)this.getEntityManager().merge((Object)entity);
            this.getEntityManager().remove((Object)mergedObject);
            return mergedObject;
        });
    }

    @Override
    public List<E> delete(E ... entities) {
        return this.getTransaction().exec(() -> {
            ArrayList<Serializable> list = new ArrayList<Serializable>();
            for (Serializable e : entities) {
                list.add(this.delete((E)e));
            }
            return list;
        });
    }

    @Override
    public E lock(E entity, LockModeType lockMode) {
        return (E)this.getTransaction().exec(() -> {
            this.getEntityManager().lock((Object)entity, lockMode);
            this.getEntityManager().detach((Object)entity);
            Serializable merged = (Serializable)this.getEntityManager().merge((Object)entity);
            this.getEntityManager().flush();
            return merged;
        });
    }

    protected Select<E> select(String query, boolean nativeQuery) {
        SelectImpl select = new SelectImpl(this.getEntityManager(), this.getTransaction());
        select.setQuery(query, nativeQuery);
        return select;
    }

    protected Select<E> select(String query) {
        SelectImpl select = new SelectImpl(this.getEntityManager(), this.getTransaction());
        select.setQuery(query);
        return select;
    }

    protected Select<E> select(CriteriaQuery<E> query) {
        SelectImpl<E> select = new SelectImpl<E>(this.getEntityManager(), this.getTransaction());
        select.setQuery(query);
        return select;
    }

    protected Select<E> select(TypedQuery<E> query) {
        SelectImpl<E> select = new SelectImpl<E>(this.getEntityManager(), this.getTransaction());
        select.setQuery(query);
        return select;
    }

    protected Update<E> update(String query, boolean nativeQuery) {
        UpdateImpl update = new UpdateImpl(this.getEntityManager(), this.getTransaction());
        update.setQuery(query, nativeQuery);
        return update;
    }

    @Override
    protected Update<E> update(String query) {
        UpdateImpl update = new UpdateImpl(this.getEntityManager(), this.getTransaction());
        update.setQuery(query);
        return update;
    }

    @Override
    protected Update<E> update(TypedQuery<E> query) {
        UpdateImpl update = new UpdateImpl(this.getEntityManager(), this.getTransaction());
        update.setQuery(query);
        return update;
    }

    protected TypedQuery<E> getFindAllQuery() {
        CriteriaBuilder builder = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery criteriaQuery = builder.createQuery(this.getEntityClass());
        Root root = criteriaQuery.from(this.getEntityClass());
        criteriaQuery.select((Selection)root);
        return this.getEntityManager().createQuery(criteriaQuery);
    }

    @Override
    public List<E> findAll() {
        return this.getFindAllQuery().getResultList();
    }
}

