/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.tools.android.dependencies;

import com.dynatrace.tools.android.Version;
import java.util.function.Consumer;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentArtifactVerifier
implements Consumer<ResolvedComponentResult> {
    private static final Logger logger = LoggerFactory.getLogger((String)"AgentArtifactVerifier");
    private static final String GROUP_ID = "com.dynatrace.agent";
    private static final String MOBILE_AGENT = "agent-android";
    private static final String SESSION_REPLAY = "android-replay-agent";

    @Override
    public void accept(ResolvedComponentResult resolvedComponentResult) {
        ModuleVersionIdentifier moduleVersion = resolvedComponentResult.getModuleVersion();
        if (moduleVersion == null) {
            return;
        }
        if (!GROUP_ID.equals(moduleVersion.getGroup())) {
            return;
        }
        if (MOBILE_AGENT.equals(moduleVersion.getName())) {
            this.verify("OneAgent", moduleVersion.getVersion());
        } else if (SESSION_REPLAY.equals(moduleVersion.getName())) {
            this.verify("Session Replay", moduleVersion.getVersion());
        }
    }

    private void verify(String artifactName, String version) {
        if (!Version.getFullVersion().equals(version)) {
            throw new GradleException("Dynatrace Android Gradle plugin version " + Version.getFullVersion() + " and " + artifactName + " version " + version + " are not compatible");
        }
        logger.debug(artifactName + " version " + version + " confirmed");
    }
}

