/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.transform.factory;

import com.dynatrace.android.instrumentation.ClassResolver;
import com.dynatrace.android.instrumentation.MethodInfo;
import com.dynatrace.android.instrumentation.sensor.SensorGroup;
import com.dynatrace.android.instrumentation.sensor.SensorGroupImpl;
import com.dynatrace.android.instrumentation.sensor.agent.AutoStartTransformation;
import com.dynatrace.android.instrumentation.sensor.agent.ConfigurationBuilderTransformation;
import com.dynatrace.android.instrumentation.sensor.agent.ConfigurationPresetSensorFactory;
import com.dynatrace.android.instrumentation.sensor.agent.ManualStartTransformation;
import com.dynatrace.android.instrumentation.sensor.agent.PresetConfiguration;
import com.dynatrace.android.instrumentation.sensor.instruction.InstructionSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensor;
import com.dynatrace.android.instrumentation.sensor.method.MethodSensorImpl;
import com.dynatrace.android.instrumentation.shared.SubTransformer;
import com.dynatrace.android.instrumentation.transform.DefaultSubTransformer;
import com.dynatrace.android.instrumentation.transform.factory.TransformerFactory;
import com.dynatrace.android.instrumentation.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AgentConfigurationTransformerFactory
implements TransformerFactory {
    private static final String CONFIG_FACTORY_CLASS = "com.dynatrace.android.agent.conf.ConfigurationFactory";
    private static final String CONFIG_BUILDER_CLASS = "com.dynatrace.android.agent.conf.ConfigurationBuilder";
    private static final String CONFIG_CLASS = "com.dynatrace.android.agent.conf.Configuration";
    private static final String AGENT_MODE_CLASS = "com.dynatrace.android.agent.conf.AgentMode";
    private final AutoStartTransformation.BuilderConfiguration builderConfig;
    private final PresetConfiguration presetConfig;

    public AgentConfigurationTransformerFactory(AutoStartTransformation.BuilderConfiguration builderConfig, PresetConfiguration presetConfig) {
        this.builderConfig = builderConfig;
        this.presetConfig = presetConfig;
    }

    @Override
    public SubTransformer generateTransformer(ClassResolver classResolver) throws Exception {
        ArrayList<SensorGroup<MethodSensor>> methodSensors = new ArrayList<SensorGroup<MethodSensor>>();
        methodSensors.add(this.generateConfigurationBuilderSensor());
        methodSensors.add(this.generateConfigurationFactorySensor());
        methodSensors.add(new ConfigurationPresetSensorFactory(this.presetConfig).generateConfigurationPresetSensor());
        return new DefaultSubTransformer("AgentConfigurationTransformer", new ArrayList<SensorGroup<InstructionSensor>>(), methodSensors, classResolver);
    }

    @Override
    public List<String> mandatoryClasses() {
        return Arrays.asList(CONFIG_FACTORY_CLASS, CONFIG_BUILDER_CLASS, "com.dynatrace.android.agent.conf.ConfigurationPreset");
    }

    private SensorGroup<MethodSensor> generateConfigurationFactorySensor() {
        MethodInfo methodInfo = new MethodInfo("getConfiguration", "()L" + Utils.dotToSlash(CONFIG_CLASS) + ";", 9, null, new ArrayList<String>());
        return new SensorGroupImpl<MethodSensor>(otherClassInfo -> CONFIG_FACTORY_CLASS.equals(otherClassInfo.getName()), new MethodSensorImpl(methodInfo, this.builderConfig != null ? new AutoStartTransformation(this.builderConfig) : new ManualStartTransformation()));
    }

    private SensorGroup<MethodSensor> generateConfigurationBuilderSensor() {
        MethodInfo methodInfo = new MethodInfo("<init>", "(L" + Utils.dotToSlash(AGENT_MODE_CLASS) + ";Ljava/lang/String;Ljava/lang/String;)V", 0, null, new ArrayList<String>());
        return new SensorGroupImpl<MethodSensor>(otherClassInfo -> CONFIG_BUILDER_CLASS.equals(otherClassInfo.getName()), new MethodSensorImpl(methodInfo, new ConfigurationBuilderTransformation()));
    }
}

