/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.sensor.method;

import com.dynatrace.android.instrumentation.MethodInstruction;
import com.dynatrace.android.instrumentation.sensor.method.MethodTransformation;
import com.dynatrace.android.instrumentation.sensor.method.ParameterInstructionProvider;
import com.dynatrace.android.instrumentation.shared.TransformerUtils;
import com.dynatrace.android.instrumentation.util.Utils;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class StartMethodTransformation
implements MethodTransformation {
    private final MethodInstruction methodInstruction;
    private final ParameterInstructionProvider startParamInstrProvider;

    public StartMethodTransformation(MethodInstruction methodInstruction, ParameterInstructionProvider startParamInstrProvider) {
        this.methodInstruction = methodInstruction;
        this.startParamInstrProvider = startParamInstrProvider;
    }

    @Override
    public void transformMethod(MethodNode methodNode, int startParameterIndex) {
        TransformerUtils.insertAtMethodStart(methodNode, instructions -> {
            if (this.startParamInstrProvider != null) {
                this.startParamInstrProvider.addParameterInstructions(instructions, startParameterIndex);
            }
            instructions.add((AbstractInsnNode)Utils.generateMethodInstructionNode(this.methodInstruction));
        });
    }
}

