/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.sensor.compose.replay.transformation;

import com.dynatrace.android.instrumentation.ClassResolver;
import com.dynatrace.android.instrumentation.sensor.compose.version.ComposeUi;
import com.dynatrace.android.instrumentation.sensor.method.MethodTransformation;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ComposeReplayBasicTextFieldTransformation
implements MethodTransformation {
    private final String instrumentedClassInstruction;
    private final String basicTextFieldCallback;
    private final String composePackage;

    public ComposeReplayBasicTextFieldTransformation(ClassResolver classResolver, String instruction) {
        this.composePackage = ComposeUi.getVersionPackage(classResolver);
        this.basicTextFieldCallback = this.composePackage + "/callback/WrappingBasicTextFieldComposeCallback";
        this.instrumentedClassInstruction = instruction;
    }

    @Override
    public void transformMethod(MethodNode methodNode, int startParameterIndex) {
        InsnList instructions = methodNode.instructions;
        for (AbstractInsnNode insnNode : instructions) {
            InsnList list = new InsnList();
            if (insnNode instanceof TypeInsnNode && insnNode.getOpcode() == 187 && ((TypeInsnNode)insnNode).desc.equals(this.instrumentedClassInstruction)) {
                list.add((AbstractInsnNode)new TypeInsnNode(187, this.basicTextFieldCallback));
                list.add((AbstractInsnNode)new InsnNode(89));
                instructions.insertBefore(insnNode, list);
            }
            if (!(insnNode instanceof MethodInsnNode) || insnNode.getOpcode() != 183 || !((MethodInsnNode)insnNode).name.equals("<init>") || !((MethodInsnNode)insnNode).owner.equals(this.instrumentedClassInstruction)) continue;
            this.addCustomModifier(list);
            list.add((AbstractInsnNode)new VarInsnNode(25, 2));
            list.add((AbstractInsnNode)new MethodInsnNode(183, this.basicTextFieldCallback, "<init>", "(Lkotlin/jvm/functions/Function1;Landroidx/compose/ui/Modifier;)V"));
            instructions.insert(insnNode, list);
        }
    }

    private void addCustomModifier(InsnList list) {
        list.add((AbstractInsnNode)new VarInsnNode(25, 2));
        list.add((AbstractInsnNode)new TypeInsnNode(187, this.composePackage + "/model/DTInputTextModifier"));
        list.add((AbstractInsnNode)new InsnNode(89));
        list.add((AbstractInsnNode)new MethodInsnNode(183, this.composePackage + "/model/DTInputTextModifier", "<init>", "()V", false));
        list.add((AbstractInsnNode)new MethodInsnNode(185, "androidx/compose/ui/Modifier", "then", "(Landroidx/compose/ui/Modifier;)Landroidx/compose/ui/Modifier;", true));
        list.add((AbstractInsnNode)new VarInsnNode(58, 2));
    }
}

