/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.metric.util;

import com.dynatrace.metric.util.CodePoints;

final class UnitValidator {
    private UnitValidator() {
    }

    static boolean isValidUnit(String unit) {
        int codePoint;
        if (unit == null || unit.isEmpty()) {
            return false;
        }
        int length = unit.length();
        if (length > 63) {
            return false;
        }
        for (int offset = 0; offset < length; offset += Character.charCount(codePoint)) {
            codePoint = unit.codePointAt(offset);
            if (UnitValidator.isAllowedChar(codePoint)) continue;
            return false;
        }
        return true;
    }

    private static boolean isAllowedChar(int codePoint) {
        return UnitValidator.isLetter(codePoint) || UnitValidator.isNumber(codePoint) || codePoint == CodePoints.PERCENT_SIGN || codePoint == CodePoints.OPEN_SQUARE_BRACKET || codePoint == CodePoints.CLOSE_SQUARE_BRACKET || codePoint == CodePoints.FORWARD_SLASH || codePoint == CodePoints.UNDERSCORE;
    }

    private static boolean isLetter(int codePoint) {
        return codePoint >= CodePoints.A_LOWERCASE && codePoint <= CodePoints.Z_LOWERCASE || codePoint >= CodePoints.A_UPPERCASE && codePoint <= CodePoints.Z_UPPERCASE;
    }

    private static boolean isNumber(int codePoint) {
        return codePoint >= CodePoints.ZERO && codePoint <= CodePoints.NINE;
    }
}

