/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.metric.util;

import java.util.function.Supplier;

final class NormalizationResult {
    private static final NormalizationResult EMPTY_INVALID = new NormalizationResult(null, MessageType.ERROR, null);
    private final String result;
    private final MessageType messageType;
    private final Supplier<String> message;

    private NormalizationResult(String result, MessageType messageType, Supplier<String> message) {
        this.result = result;
        this.messageType = messageType;
        this.message = message;
    }

    static NormalizationResult newValid(String result) {
        return new NormalizationResult(result, MessageType.NONE, null);
    }

    static NormalizationResult newValid(String result, Supplier<String> message) {
        return new NormalizationResult(result, MessageType.WARNING, message);
    }

    static NormalizationResult newInvalid() {
        return EMPTY_INVALID;
    }

    static NormalizationResult newInvalid(Supplier<String> message) {
        return new NormalizationResult(null, MessageType.ERROR, message);
    }

    String getResult() {
        return this.result;
    }

    String getMessage() {
        return this.message.get();
    }

    MessageType messageType() {
        return this.messageType;
    }

    static enum MessageType {
        WARNING,
        ERROR,
        NONE;

    }
}

