/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.metric.util;

import com.dynatrace.metric.util.CodePoints;
import com.dynatrace.metric.util.DimensionKeyValidator;
import com.dynatrace.metric.util.DynatraceMetadataEnricher;
import com.dynatrace.metric.util.MetricException;
import com.dynatrace.metric.util.NormalizationResult;
import com.dynatrace.metric.util.Normalizer;
import com.dynatrace.metric.util.StringValueValidator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.logging.Logger;

public class MetricLinePreConfiguration {
    private static final Logger logger = Logger.getLogger(MetricLinePreConfiguration.class.getName());
    private static final MetricLinePreConfiguration EMPTY_PRE_CONFIG = new MetricLinePreConfiguration(null, Collections.emptyMap(), Collections.emptyMap(), 0);
    private final Map<String, String> dynatraceMetadataDimensions;
    private final Map<String, String> defaultDimensions;
    private final String prefix;
    private final int serializationLength;

    private MetricLinePreConfiguration(String prefix, Map<String, String> defaultDimensions, Map<String, String> dynatraceMetadataDimensions, int serializationLength) {
        this.prefix = prefix;
        this.defaultDimensions = defaultDimensions;
        this.dynatraceMetadataDimensions = dynatraceMetadataDimensions;
        this.serializationLength = serializationLength;
    }

    public Map<String, String> getDynatraceMetadataDimensions() {
        return this.dynatraceMetadataDimensions;
    }

    public Map<String, String> getDefaultDimensions() {
        return this.defaultDimensions;
    }

    public String getPrefix() {
        return this.prefix;
    }

    int preConfigSerializedLength() {
        return this.serializationLength;
    }

    static MetricLinePreConfiguration empty() {
        return EMPTY_PRE_CONFIG;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Map<String, String> defaultDimensions = null;
        private boolean withDynatraceMetadataDimensions = false;
        private String prefix;
        private int dimensionCount = 0;
        private int serializationLength = 0;

        private Builder() {
        }

        public Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder defaultDimensions(Map<String, String> defaultDimensions) throws MetricException {
            if (defaultDimensions.size() > 50) {
                throw new MetricException("Too many dimensions were tried to be set, max limit of 50 surpassed");
            }
            this.defaultDimensions = defaultDimensions;
            return this;
        }

        public Builder dynatraceMetadataDimensions() {
            this.withDynatraceMetadataDimensions = true;
            return this;
        }

        public MetricLinePreConfiguration build() throws MetricException {
            HashMap<String, String> normalizedDefaultDimensions = new HashMap<String, String>();
            HashMap<String, String> normalizedDynatraceMetadataDimensions = new HashMap<String, String>();
            this.dimensionCount = 0;
            this.serializationLength = 0;
            if (this.withDynatraceMetadataDimensions) {
                Map<String, String> dynatraceMetadataDimensions = DynatraceMetadataEnricher.getDynatraceMetadata();
                if (dynatraceMetadataDimensions.isEmpty()) {
                    logger.warning(() -> "Received empty Dynatrace metadata dimensions. Continuing without Dynatrace metadata.");
                } else {
                    for (Map.Entry<String, String> entry : dynatraceMetadataDimensions.entrySet()) {
                        this.dimension(entry.getKey(), entry.getValue(), normalizedDynatraceMetadataDimensions, key -> false);
                    }
                }
            }
            if (this.defaultDimensions != null) {
                if (this.defaultDimensions.isEmpty()) {
                    logger.warning(() -> "Received empty default dimensions. Continuing without default dimensions.");
                }
                for (Map.Entry<String, String> entry : this.defaultDimensions.entrySet()) {
                    this.dimension(entry.getKey(), entry.getValue(), normalizedDefaultDimensions, normalizedDynatraceMetadataDimensions::containsKey);
                }
            }
            return new MetricLinePreConfiguration(this.prefix, normalizedDefaultDimensions, normalizedDynatraceMetadataDimensions, this.serializationLength);
        }

        private void dimension(String key, String value, Map<String, String> targetDimensions, Predicate<String> shouldBeIgnored) throws MetricException {
            NormalizationResult normalizationResult;
            if (StringValueValidator.isNullOrEmpty(key)) {
                logger.warning(() -> "Dimension with empty dimension key has been dropped");
                return;
            }
            String normalizedKey = key;
            if (DimensionKeyValidator.normalizationRequired(key)) {
                normalizationResult = Normalizer.normalizeDimensionKey(key);
                normalizedKey = normalizationResult.getResult();
                if (normalizationResult.messageType() != NormalizationResult.MessageType.NONE) {
                    logger.warning(() -> normalizationResult.getMessage());
                }
            }
            if (shouldBeIgnored.test(normalizedKey)) {
                logger.info(() -> String.format("Dimension value '%s' for key '%s' skipped: Using value from pre-configuration instead.", value, key));
                return;
            }
            normalizationResult = Normalizer.normalizeDimensionValue(value, 250);
            if (normalizationResult.messageType() != NormalizationResult.MessageType.NONE) {
                logger.warning(() -> normalizationResult.getMessage());
            }
            this.tryAddDimensionTo(normalizedKey, normalizationResult.getResult(), targetDimensions);
        }

        private void tryAddDimensionTo(String normalizedKey, String normalizedValue, Map<String, String> targetDimensions) throws MetricException {
            if (StringValueValidator.isNullOrEmpty(normalizedKey)) {
                logger.warning(() -> "Dimension with empty dimension key has been dropped");
                return;
            }
            if (this.dimensionCount + 1 > 50) {
                throw new MetricException("Too many dimensions were tried to be set, max limit of 50 surpassed");
            }
            this.serializationLength += normalizedKey.length() + Character.charCount(CodePoints.EQUALS) + normalizedValue.length() + Character.charCount(CodePoints.COMMA);
            if (this.serializationLength > 50000) {
                throw new MetricException("Serialized line exceeds limit of 50000 characters accepted by the ingest API'");
            }
            ++this.dimensionCount;
            targetDimensions.put(normalizedKey, normalizedValue);
        }
    }
}

