/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.metric.util;

import com.dynatrace.metric.util.BooleanResultMessage;
import com.dynatrace.metric.util.CodePoints;
import com.dynatrace.metric.util.DimensionKeyValidator;
import com.dynatrace.metric.util.MetricException;
import com.dynatrace.metric.util.MetricKeyValidator;
import com.dynatrace.metric.util.MetricLineBuilder;
import com.dynatrace.metric.util.MetricLinePreConfiguration;
import com.dynatrace.metric.util.NormalizationResult;
import com.dynatrace.metric.util.Normalizer;
import com.dynatrace.metric.util.NumberValueValidator;
import com.dynatrace.metric.util.StringValueValidator;
import com.dynatrace.metric.util.UnitValidator;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.logging.Logger;

class MetricLineBuilderImpl
implements MetricLineBuilder.MetricKeyStep,
MetricLineBuilder.TypeStep,
MetricLineBuilder.GaugeStep,
MetricLineBuilder.CounterStep,
MetricLineBuilder.TimestampOrBuildStep,
MetricLineBuilder.BuildStep {
    private static final Logger logger = Logger.getLogger(MetricLineBuilderImpl.class.getName());
    private static final AtomicInteger timestampWarningCounter = new AtomicInteger(0);
    private static final int TIMESTAMP_WARNING_THROTTLE_FACTOR = 1000;
    private static final int MINIMUM_CAPACITY = 72;
    private static final String PREFIX_STRING = "[%s] %s";
    private final MetricLinePreConfiguration preConfig;
    private final Map<String, String> dimensions = new HashMap<String, String>();
    private String metricKey;
    private String type;
    private int descriptorLength;
    private int dimensionCount;
    private StringBuilder payloadBuilder;

    private MetricLineBuilderImpl(MetricLinePreConfiguration preConfig) {
        this.preConfig = preConfig;
        this.dimensionCount = this.preConfig.getDefaultDimensions().size() + this.preConfig.getDynatraceMetadataDimensions().size();
        this.descriptorLength = this.preConfig.preConfigSerializedLength();
    }

    static MetricLineBuilder.MetricKeyStep builder(MetricLinePreConfiguration preConfig) {
        return new MetricLineBuilderImpl(preConfig);
    }

    @Override
    public MetricLineBuilder.TypeStep metricKey(String key) throws MetricException {
        if (StringValueValidator.isNullOrEmpty(key)) {
            throw new MetricException("Metric key is empty");
        }
        String string = this.metricKey = StringValueValidator.isNullOrEmpty(this.preConfig.getPrefix()) ? key : this.preConfig.getPrefix() + CodePoints.DOT_AS_STRING + key;
        if (MetricKeyValidator.normalizationRequired(this.metricKey)) {
            NormalizationResult normalizationResult = Normalizer.normalizeMetricKey(this.metricKey);
            if (normalizationResult.messageType() == NormalizationResult.MessageType.WARNING) {
                logger.warning(() -> normalizationResult.getMessage());
            } else if (normalizationResult.messageType() == NormalizationResult.MessageType.ERROR) {
                throw new MetricException(String.format("Metric key invalid after normalization. Pre-normalization key: '%s'", key));
            }
            this.metricKey = normalizationResult.getResult();
        }
        this.descriptorLength += this.metricKey.length();
        if (this.descriptorLength > 50000) {
            throw new MetricException(String.format("[%s] Serialized line exceeds limit of 50000 characters accepted by the ingest API'", key));
        }
        return this;
    }

    @Override
    public MetricLineBuilder.TypeStep dimension(String key, String value) throws MetricException {
        if (StringValueValidator.isNullOrEmpty(key)) {
            logger.warning(() -> String.format("[%s] Dimension with empty dimension key has been dropped", this.metricKey));
            return this;
        }
        String normalizedKey = key;
        if (DimensionKeyValidator.normalizationRequired(key)) {
            NormalizationResult normalizationResult = Normalizer.normalizeDimensionKey(key);
            normalizedKey = normalizationResult.getResult();
            if (normalizationResult.messageType() != NormalizationResult.MessageType.NONE) {
                logger.warning(() -> String.format(PREFIX_STRING, this.metricKey, normalizationResult.getMessage()));
            }
        }
        if (this.preConfig.getDynatraceMetadataDimensions().containsKey(normalizedKey)) {
            logger.info(() -> String.format("[%s] Dimension value '%s' for key '%s' skipped: Using value from pre-configuration instead.", this.metricKey, value, key));
            return this;
        }
        NormalizationResult normalizedValue = Normalizer.normalizeDimensionValue(value, 250);
        if (normalizedValue.messageType() != NormalizationResult.MessageType.NONE) {
            logger.warning(() -> String.format(PREFIX_STRING, this.metricKey, normalizedValue.getMessage()));
        }
        this.tryAddDimension(normalizedKey, normalizedValue.getResult(), !this.preConfig.getDefaultDimensions().containsKey(normalizedKey));
        return this;
    }

    @Override
    public MetricLineBuilder.TypeStep dimensions(Map<String, String> dimensions) throws MetricException {
        if (dimensions == null || dimensions.isEmpty()) {
            return this;
        }
        if (dimensions.size() > 50) {
            throw new MetricException(String.format("[%s] Too many dimensions were tried to be set, max limit of 50 surpassed", this.metricKey));
        }
        for (Map.Entry<String, String> entry : dimensions.entrySet()) {
            this.dimension(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public MetricLineBuilder.GaugeStep gauge() {
        this.type = "gauge";
        return this;
    }

    @Override
    public MetricLineBuilder.CounterStep count() {
        this.type = "count";
        return this;
    }

    @Override
    public MetricLineBuilder.TimestampOrBuildStep summary(double min, double max, double sum, long count) throws MetricException {
        BooleanResultMessage result = NumberValueValidator.isSummaryValid(min, max, sum, count);
        if (!result.isValid()) {
            throw new MetricException(String.format(PREFIX_STRING, this.metricKey, result.getMessage()));
        }
        this.payloadBuilder = new StringBuilder(72).append("min=").append(Normalizer.doubleToString(min)).append(",max=").append(Normalizer.doubleToString(max)).append(",sum=").append(Normalizer.doubleToString(sum)).append(",count=").append(count);
        return this;
    }

    @Override
    public MetricLineBuilder.TimestampOrBuildStep value(double value) throws MetricException {
        BooleanResultMessage result = NumberValueValidator.isValueValid(value);
        if (!result.isValid()) {
            throw new MetricException(String.format(PREFIX_STRING, this.metricKey, result.getMessage()));
        }
        this.payloadBuilder = new StringBuilder(72).append(Normalizer.doubleToString(value));
        return this;
    }

    @Override
    public MetricLineBuilder.TimestampOrBuildStep delta(double delta) throws MetricException {
        BooleanResultMessage result = NumberValueValidator.isValueValid(delta);
        if (!result.isValid()) {
            throw new MetricException(String.format(PREFIX_STRING, this.metricKey, result.getMessage()));
        }
        this.payloadBuilder = new StringBuilder(72).append("delta=").append(Normalizer.doubleToString(delta));
        return this;
    }

    @Override
    public MetricLineBuilder.BuildStep timestamp(Instant timestamp) {
        if (timestamp == null) {
            logger.warning(() -> String.format("[%s] Skip setting timestamp, because it is null", this.metricKey));
            return this;
        }
        int year = timestamp.atZone(ZoneOffset.UTC).getYear();
        if (year < 2000 || year > 3000) {
            if (timestampWarningCounter.getAndIncrement() == 0) {
                logger.warning(() -> String.format("[%s] Order of magnitude of the timestamp seems off (%s). The timestamp represents a time before the year 2000 or after the year 3000. Skipping setting timestamp, the current server time will be added upon ingestion. Only one out of every %d of these messages will be printed.", this.metricKey, timestamp, 1000));
            }
            timestampWarningCounter.compareAndSet(1000, 0);
            return this;
        }
        this.payloadBuilder.appendCodePoint(CodePoints.BLANK).append(timestamp.toEpochMilli());
        return this;
    }

    @Override
    public MetricLineBuilder.MetadataStep metadata() {
        return new MetadataLineBuilderImpl();
    }

    @Override
    public String build() throws MetricException {
        StringBuilder lineBuilder = new StringBuilder(this.descriptorLength + Character.charCount(CodePoints.BLANK) + this.type.length() + Character.charCount(CodePoints.COMMA) + this.payloadBuilder.length());
        lineBuilder.append(this.metricKey);
        this.serializeDimensionMapAndAppend(lineBuilder, this.preConfig.getDefaultDimensions(), this.dimensions::containsKey);
        this.serializeDimensionMapAndAppend(lineBuilder, this.dimensions, key -> false);
        this.serializeDimensionMapAndAppend(lineBuilder, this.preConfig.getDynatraceMetadataDimensions(), key -> false);
        lineBuilder.appendCodePoint(CodePoints.BLANK).append(this.type).appendCodePoint(CodePoints.COMMA).append((CharSequence)this.payloadBuilder);
        if (lineBuilder.length() > 50000) {
            throw new MetricException(String.format("[%s] Serialized line exceeds limit of 50000 characters accepted by the ingest API'", this.metricKey));
        }
        return lineBuilder.toString();
    }

    private void tryAddDimension(String normalizedKey, String normalizedValue, boolean shouldIncrement) throws MetricException {
        if (StringValueValidator.isNullOrEmpty(normalizedKey)) {
            logger.warning(() -> String.format("[%s] Dimension with empty dimension key has been dropped", this.metricKey));
            return;
        }
        if (this.dimensionCount + 1 > 50) {
            throw new MetricException(String.format("[%s] Too many dimensions were tried to be set, max limit of 50 surpassed", this.metricKey));
        }
        if (shouldIncrement) {
            ++this.dimensionCount;
        }
        this.descriptorLength += normalizedKey.length() + Character.charCount(CodePoints.DOT) + normalizedValue.length() + Character.charCount(CodePoints.COMMA);
        this.dimensions.put(normalizedKey, normalizedValue);
    }

    private void serializeDimensionMapAndAppend(StringBuilder sb, Map<String, String> dimensionsToSerialize, Predicate<String> shouldBeIgnored) {
        for (Map.Entry<String, String> entry : dimensionsToSerialize.entrySet()) {
            if (shouldBeIgnored.test(entry.getKey())) continue;
            if (StringValueValidator.isNullOrEmpty(entry.getValue())) {
                logger.warning(() -> String.format("[%s] Dimension value for dimension key '%s' is null or empty", this.metricKey, entry.getKey()));
                continue;
            }
            sb.appendCodePoint(CodePoints.COMMA).append(entry.getKey()).appendCodePoint(CodePoints.EQUALS).append(entry.getValue());
        }
    }

    public class MetadataLineBuilderImpl
    implements MetricLineBuilder.MetadataStep {
        private String unit = null;
        private String description = null;
        private String displayName = null;

        private MetadataLineBuilderImpl() {
        }

        @Override
        public MetricLineBuilder.MetadataStep description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public MetricLineBuilder.MetadataStep displayName(String name) {
            this.displayName = name;
            return this;
        }

        @Override
        public MetricLineBuilder.MetadataStep unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public String build() {
            NormalizationResult normalizationResult;
            StringBuilder payload = new StringBuilder(72);
            if (this.description != null) {
                if (StringValueValidator.isNullOrEmpty(this.description) || StringValueValidator.isEmptyQuoted(this.description)) {
                    logger.warning(() -> String.format("[%s] Description '%s' dropped", MetricLineBuilderImpl.this.metricKey, this.description));
                } else {
                    String normalizedDescription;
                    normalizationResult = Normalizer.normalizeDimensionValue(this.description, 65535);
                    if (normalizationResult.messageType() != NormalizationResult.MessageType.NONE) {
                        logger.warning(() -> String.format(MetricLineBuilderImpl.PREFIX_STRING, MetricLineBuilderImpl.this.metricKey, normalizationResult.getMessage()));
                    }
                    if (StringValueValidator.isNullOrEmpty(normalizedDescription = normalizationResult.getResult()) || StringValueValidator.isEmptyQuoted(normalizedDescription)) {
                        logger.warning(() -> String.format("[%s] Description '%s' dropped", MetricLineBuilderImpl.this.metricKey, this.description));
                    } else {
                        payload.append("dt.meta.description").appendCodePoint(CodePoints.EQUALS).append(normalizedDescription);
                    }
                }
            }
            if (this.unit != null) {
                if (!UnitValidator.isValidUnit(this.unit)) {
                    logger.warning(() -> String.format("[%s] Unit '%s' dropped", MetricLineBuilderImpl.this.metricKey, this.unit));
                } else {
                    if (payload.length() > 0) {
                        payload.appendCodePoint(CodePoints.COMMA);
                    }
                    payload.append("dt.meta.unit").appendCodePoint(CodePoints.EQUALS).append(this.unit);
                }
            }
            if (this.displayName != null) {
                if (StringValueValidator.isNullOrEmpty(this.displayName) || StringValueValidator.isEmptyQuoted(this.displayName)) {
                    logger.warning(() -> String.format("[%s] Display name '%s' dropped", MetricLineBuilderImpl.this.metricKey, this.displayName));
                } else {
                    String normalizedDisplayName;
                    normalizationResult = Normalizer.normalizeDimensionValue(this.displayName, 300);
                    if (normalizationResult.messageType() != NormalizationResult.MessageType.NONE) {
                        logger.warning(() -> String.format(MetricLineBuilderImpl.PREFIX_STRING, MetricLineBuilderImpl.this.metricKey, normalizationResult.getMessage()));
                    }
                    if (StringValueValidator.isNullOrEmpty(normalizedDisplayName = normalizationResult.getResult()) || StringValueValidator.isEmptyQuoted(normalizedDisplayName)) {
                        logger.warning(() -> String.format("[%s] Display name '%s' dropped", MetricLineBuilderImpl.this.metricKey, this.displayName));
                    } else {
                        if (payload.length() > 0) {
                            payload.appendCodePoint(CodePoints.COMMA);
                        }
                        payload.append("dt.meta.displayName").appendCodePoint(CodePoints.EQUALS).append(normalizedDisplayName);
                    }
                }
            }
            if (payload.length() == 0) {
                logger.warning(() -> String.format("No data set to serialize the metadata for the metric '%s'", MetricLineBuilderImpl.this.metricKey));
                return null;
            }
            StringBuilder sb = new StringBuilder(Character.charCount(CodePoints.NUMBER_SIGN) + MetricLineBuilderImpl.this.metricKey.length() + Character.charCount(CodePoints.BLANK) + MetricLineBuilderImpl.this.type.length() + Character.charCount(CodePoints.BLANK) + payload.length());
            return sb.appendCodePoint(CodePoints.NUMBER_SIGN).append(MetricLineBuilderImpl.this.metricKey).appendCodePoint(CodePoints.BLANK).append(MetricLineBuilderImpl.this.type).appendCodePoint(CodePoints.BLANK).append((CharSequence)payload).toString();
        }
    }
}

