/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.logging;

import com.dynatrace.android.logging.AndroidNativeLogger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0012\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u000e\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u000e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u000e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u000e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u000e\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u000e\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u000e\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u000e\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u000e\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0007J\u000e\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0007J\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0002J\u0010\u0010\u001b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0002J\b\u0010\u001c\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/dynatrace/android/logging/DTLogger;", "", "<init>", "()V", "TAG", "", "logThread", "", "androidNativeLogger", "Lcom/dynatrace/android/logging/AndroidNativeLogger;", "api", "", "msg", "sync", "db", "storage", "config", "trackingOp", "tracking", "info", "warning", "error", "enableLogs", "enable", "logThreads", "enabled", "composeMessage", "sanitizeMessage", "threadPrefix", "logging_release"})
public final class DTLogger {
    @NotNull
    public static final DTLogger INSTANCE = new DTLogger();
    @NotNull
    private static final String TAG = "dtxSessionReplay";
    private static boolean logThread;
    @Nullable
    private static AndroidNativeLogger androidNativeLogger;

    private DTLogger() {
    }

    public final void api(@NotNull String msg) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            AndroidNativeLogger androidNativeLogger = DTLogger.androidNativeLogger;
            if (androidNativeLogger == null) break block0;
            androidNativeLogger.debug(TAG, "\ud83d\udd2e Api -> " + this.composeMessage(msg));
        }
    }

    public final void sync(@NotNull String msg) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            AndroidNativeLogger androidNativeLogger = DTLogger.androidNativeLogger;
            if (androidNativeLogger == null) break block0;
            androidNativeLogger.debug(TAG, ": \ud83d\udd04 Sync -> " + this.composeMessage(msg));
        }
    }

    public final void db(@NotNull String msg) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            AndroidNativeLogger androidNativeLogger = DTLogger.androidNativeLogger;
            if (androidNativeLogger == null) break block0;
            androidNativeLogger.debug(TAG, "\ud83e\uddf5 DB -> " + this.composeMessage(msg));
        }
    }

    public final void storage(@NotNull String msg) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            AndroidNativeLogger androidNativeLogger = DTLogger.androidNativeLogger;
            if (androidNativeLogger == null) break block0;
            androidNativeLogger.debug(TAG, "\ud83d\udcc2 Storage -> " + this.composeMessage(msg));
        }
    }

    public final void config(@NotNull String msg) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            AndroidNativeLogger androidNativeLogger = DTLogger.androidNativeLogger;
            if (androidNativeLogger == null) break block0;
            androidNativeLogger.debug(TAG, "\u2699\ufe0f Config -> " + this.composeMessage(msg));
        }
    }

    public final void trackingOp(@NotNull String msg) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            AndroidNativeLogger androidNativeLogger = DTLogger.androidNativeLogger;
            if (androidNativeLogger == null) break block0;
            androidNativeLogger.debug(TAG, "TrackOp -> " + this.composeMessage(msg));
        }
    }

    public final void tracking(@NotNull String msg) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            AndroidNativeLogger androidNativeLogger = DTLogger.androidNativeLogger;
            if (androidNativeLogger == null) break block0;
            androidNativeLogger.debug(TAG, "\ud83d\ude9c Track -> " + this.composeMessage(msg));
        }
    }

    public final void info(@NotNull String msg) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            AndroidNativeLogger androidNativeLogger = DTLogger.androidNativeLogger;
            if (androidNativeLogger == null) break block0;
            androidNativeLogger.info(TAG, "\u2139\ufe0f Info -> " + this.composeMessage(msg));
        }
    }

    public final void warning(@NotNull String msg) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            AndroidNativeLogger androidNativeLogger = DTLogger.androidNativeLogger;
            if (androidNativeLogger == null) break block0;
            androidNativeLogger.warning(TAG, "\u26a0\ufe0f Warning -> " + this.composeMessage(msg));
        }
    }

    public final void error(@NotNull String msg) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            AndroidNativeLogger androidNativeLogger = DTLogger.androidNativeLogger;
            if (androidNativeLogger == null) break block0;
            androidNativeLogger.error(TAG, "\u274c Error -> " + this.composeMessage(msg));
        }
    }

    public final void enableLogs(boolean enable) {
        androidNativeLogger = !enable ? null : new AndroidNativeLogger();
    }

    public final void logThreads(boolean enabled) {
        logThread = enabled;
    }

    private final String composeMessage(String msg) {
        return this.threadPrefix() + this.sanitizeMessage(msg);
    }

    private final String sanitizeMessage(String msg) {
        String sanitizedMsg;
        block1: {
            Regex regex = new Regex("[^a-zA-Z0-9 .,;:_@#%&()\\[\\]{}<>='/$-]");
            CharSequence charSequence = msg;
            String string = "";
            sanitizedMsg = regex.replace(charSequence, string);
            if (Intrinsics.areEqual((Object)msg, (Object)sanitizedMsg)) break block1;
            AndroidNativeLogger androidNativeLogger = DTLogger.androidNativeLogger;
            if (androidNativeLogger != null) {
                androidNativeLogger.debug(TAG, "Log msg was sanitized as it contains invalid characters");
            }
        }
        return sanitizedMsg;
    }

    private final String threadPrefix() {
        return logThread ? "Thread [" + Thread.currentThread().getName() + "]: " : "";
    }
}

