/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.data.daos.localstorage;

import android.content.Context;
import com.dynatrace.android.logging.DTLogger;
import com.dynatrace.android.sessionreplay.data.daos.ImageDAO;
import com.dynatrace.android.sessionreplay.data.screenshots.ScreenshotInfo;
import com.dynatrace.android.sessionreplay.model.FileError;
import com.dynatrace.android.sessionreplay.model.Result;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u001d2\u00020\u0001:\u0003\u001b\u001c\u001dB\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u0016J\u001c\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u001c\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u001a\u0010\u000f\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u0010\u0012\u0004\u0012\u00020\t0\u0007H\u0016J$\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u000eH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\u0003H\u0016J\"\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0002\u001e\u001f\u00a8\u0006 "}, d2={"Lcom/dynatrace/android/sessionreplay/data/daos/localstorage/LocalStorageImageDAO;", "Lcom/dynatrace/android/sessionreplay/data/daos/ImageDAO;", "screenshotPath", "", "<init>", "(Ljava/lang/String;)V", "getCurrentStorageSize", "Lcom/dynatrace/android/sessionreplay/model/Result;", "", "Lcom/dynatrace/android/sessionreplay/model/FileError;", "getInfo", "Lcom/dynatrace/android/sessionreplay/data/screenshots/ScreenshotInfo;", "id", "get", "", "getAll", "", "save", "bytes", "delete", "", "deleteAll", "exceptions", "", "parseToMD5Characters", "getDirectory", "Ljava/io/File;", "Tmp", "Final", "Companion", "Lcom/dynatrace/android/sessionreplay/data/daos/localstorage/LocalStorageImageDAO$Final;", "Lcom/dynatrace/android/sessionreplay/data/daos/localstorage/LocalStorageImageDAO$Tmp;", "datalayer_release"})
@SourceDebugExtension(value={"SMAP\nLocalStorageImageDAO.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalStorageImageDAO.kt\ncom/dynatrace/android/sessionreplay/data/daos/localstorage/LocalStorageImageDAO\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,137:1\n12820#2,3:138\n13409#2,2:141\n13409#2,2:143\n3829#2:145\n4344#2,2:146\n2642#3:148\n1#4:149\n*S KotlinDebug\n*F\n+ 1 LocalStorageImageDAO.kt\ncom/dynatrace/android/sessionreplay/data/daos/localstorage/LocalStorageImageDAO\n*L\n22#1:138,3\n60#1:141,2\n97#1:143,2\n103#1:145\n103#1:146,2\n104#1:148\n104#1:149\n*E\n"})
public abstract class LocalStorageImageDAO
implements ImageDAO {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final String screenshotPath;
    @NotNull
    private static final String SCREENSHOTS_FOLDER = "/screenshots";
    @NotNull
    private static final String TMP_FOLDER = "/tmp";

    private LocalStorageImageDAO(String screenshotPath) {
        this.screenshotPath = screenshotPath;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public synchronized Result<Long, FileError> getCurrentStorageSize() {
        void accumulator$iv;
        File[] fileArray = this.getDirectory().listFiles();
        if (fileArray != null) {
            void $this$fold$iv;
            void initial$iv;
            File[] fileArray2 = fileArray;
            long l = 0L;
            boolean $i$f$fold = false;
            accumulator$iv = initial$iv;
            int n = ((void)$this$fold$iv).length;
            for (int i = 0; i < n; ++i) {
                void file;
                void element$iv;
                void var12_9 = element$iv = $this$fold$iv[i];
                void acc = accumulator$iv;
                boolean bl = false;
                accumulator$iv = acc + (file.isFile() ? file.length() : 0L);
            }
        } else {
            boolean bl = false;
            return (Result)new Result.Success((Object)0L);
        }
        void size = accumulator$iv;
        return (Result)new Result.Success((Object)((long)size));
    }

    @Override
    @NotNull
    public synchronized Result<ScreenshotInfo, FileError> getInfo(@NotNull String id) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        String validatedId = this.parseToMD5Characters(id);
        File file = new File(this.getDirectory(), validatedId);
        if (file.exists()) {
            result = (Result)new Result.Success((Object)new ScreenshotInfo(validatedId, file.length()));
        } else {
            String string = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            result = (Result)new Result.Error((Object)new FileError.NotFound(string));
        }
        return result;
    }

    @Override
    @NotNull
    public synchronized Result<byte[], FileError> get(@NotNull String id) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        String validatedId = this.parseToMD5Characters(id);
        File screenshotFile = new File(this.getDirectory(), validatedId);
        try {
            Result result2;
            if (screenshotFile.exists()) {
                result2 = (Result)new Result.Success((Object)FilesKt.readBytes((File)screenshotFile));
            } else {
                String string = screenshotFile.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                result2 = (Result)new Result.Error((Object)new FileError.NotFound(string));
            }
            result = result2;
        }
        catch (IOException e) {
            result = (Result)new Result.Error((Object)new FileError.IOError((Throwable)e));
        }
        return result;
    }

    @Override
    @NotNull
    public synchronized Result<List<byte[]>, FileError> getAll() {
        Result result;
        List imageList = new ArrayList();
        try {
            Result.Error error;
            File[] fileArray = this.getDirectory().listFiles();
            if (fileArray != null) {
                File[] $this$forEach$iv = fileArray;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    File element$iv;
                    File file = element$iv = $this$forEach$iv[i];
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)file);
                    imageList.add(FilesKt.readBytes((File)file));
                }
                error = Unit.INSTANCE;
            } else {
                error = new Result.Error((Object)new FileError.NotFound("Error retrieving images from directory"));
            }
            result = (Result)new Result.Success((Object)imageList);
        }
        catch (IOException e) {
            result = (Result)new Result.Error((Object)new FileError.IOError((Throwable)e));
        }
        return result;
    }

    @Override
    @NotNull
    public synchronized Result<ScreenshotInfo, FileError> save(@NotNull String id, @NotNull byte[] bytes) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        String validatedId = this.parseToMD5Characters(id);
        File screenshotFile = new File(this.getDirectory(), validatedId);
        try {
            FilesKt.writeBytes((File)screenshotFile, (byte[])bytes);
            result = (Result)new Result.Success((Object)new ScreenshotInfo(validatedId, screenshotFile.length()));
        }
        catch (IOException e) {
            result = (Result)new Result.Error((Object)new FileError.IOError((Throwable)e));
        }
        return result;
    }

    @Override
    public synchronized boolean delete(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        String validatedId = this.parseToMD5Characters(id);
        File file = new File(this.getDirectory(), validatedId);
        return file.delete();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public synchronized Result<Long, FileError> deleteAll(@NotNull Set<String> exceptions) {
        long totalSizeDeleted;
        block4: {
            void $this$onEach$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            block3: {
                Intrinsics.checkNotNullParameter(exceptions, (String)"exceptions");
                totalSizeDeleted = 0L;
                if (!exceptions.isEmpty()) break block3;
                File[] fileArray = this.getDirectory().listFiles();
                if (fileArray == null) break block4;
                File[] $this$forEach$iv = fileArray;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    File element$iv;
                    File it = element$iv = $this$forEach$iv[i];
                    boolean bl = false;
                    totalSizeDeleted += it.length();
                    it.delete();
                }
                break block4;
            }
            File[] fileArray = this.getDirectory().listFiles();
            if (fileArray == null) break block4;
            File[] $i$f$forEach = fileArray;
            boolean $i$f$filter = false;
            void var6_9 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            int n = ((void)$this$filterTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = $this$filterTo$iv$iv[i];
                boolean bl = false;
                if (!(!exceptions.contains(it.getName()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$onEach = false;
            void $this$onEach_u24lambda_u2419$iv = var6_9 = $this$onEach$iv;
            boolean bl = false;
            for (Object element$iv : $this$onEach_u24lambda_u2419$iv) {
                File it = (File)element$iv;
                boolean bl2 = false;
                totalSizeDeleted += it.length();
                it.delete();
            }
            List cfr_ignored_0 = (List)var6_9;
        }
        return (Result)new Result.Success((Object)totalSizeDeleted);
    }

    private final String parseToMD5Characters(String id) {
        Regex regex = new Regex("[^0-9a-fA-F]");
        CharSequence charSequence = id;
        String string = "";
        String parsedId = regex.replace(charSequence, string);
        if (!Intrinsics.areEqual((Object)parsedId, (Object)id)) {
            DTLogger.INSTANCE.storage("Local Storage id was parsed as it contains invalid characters");
        }
        return parsedId;
    }

    private final File getDirectory() {
        File dir = new File(this.screenshotPath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public /* synthetic */ LocalStorageImageDAO(String screenshotPath, DefaultConstructorMarker $constructor_marker) {
        this(screenshotPath);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/dynatrace/android/sessionreplay/data/daos/localstorage/LocalStorageImageDAO$Companion;", "", "<init>", "()V", "SCREENSHOTS_FOLDER", "", "TMP_FOLDER", "datalayer_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/dynatrace/android/sessionreplay/data/daos/localstorage/LocalStorageImageDAO$Final;", "Lcom/dynatrace/android/sessionreplay/data/daos/localstorage/LocalStorageImageDAO;", "appContext", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "datalayer_release"})
    public static final class Final
    extends LocalStorageImageDAO {
        public Final(@NotNull Context appContext) {
            Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
            super(appContext.getFilesDir().getAbsolutePath() + LocalStorageImageDAO.SCREENSHOTS_FOLDER, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/dynatrace/android/sessionreplay/data/daos/localstorage/LocalStorageImageDAO$Tmp;", "Lcom/dynatrace/android/sessionreplay/data/daos/localstorage/LocalStorageImageDAO;", "appContext", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "datalayer_release"})
    public static final class Tmp
    extends LocalStorageImageDAO {
        public Tmp(@NotNull Context appContext) {
            Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
            super(appContext.getFilesDir().getAbsolutePath() + LocalStorageImageDAO.TMP_FOLDER, null);
        }
    }
}

