/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.conf;

import com.dynatrace.android.agent.comm.InvalidConfigurationException;
import com.dynatrace.android.agent.conf.AgentMode;
import com.dynatrace.android.agent.conf.RageTapConfiguration;
import com.dynatrace.android.agent.conf.ReplayConfiguration;
import com.dynatrace.android.agent.conf.ServerConfiguration;
import com.dynatrace.android.agent.conf.ServerConfigurationParser;
import com.dynatrace.android.agent.conf.SessionSplitConfiguration;
import com.dynatrace.android.agent.util.Utility;
import java.text.ParseException;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class ServerConfigurationManager
implements ServerConfigurationParser {
    private static final ServerConfiguration CONFIG_AGENT_ERROR = new ServerConfiguration.Builder().withCaptureOff().withStatus(ServerConfiguration.Status.ERROR).build();
    private static final ServerConfiguration CONFIG_INIT_MEMORY = new ServerConfiguration.Builder().withTimestamp(-1L).build();
    private static final String KEY_MOBILE_AGENT_CONFIG = "mobileAgentConfig";
    private static final String KEY_APP_CONFIG = "appConfig";
    private static final String KEY_DYNAMIC_CONFIG = "dynamicConfig";
    private static final String KEY_TIMESTAMP = "timestamp";
    private static final String KEY_REPLAY_CONFIG = "replayConfig";
    private static final String KEY_MAX_BEACON_SIZE_KB = "maxBeaconSizeKb";
    private static final String KEY_SELFMONITORING = "selfmonitoring";
    private static final String KEY_MAX_SESSION_DURATION_MINS = "maxSessionDurationMins";
    private static final String KEY_SESSION_TIMEOUT_SEC = "sessionTimeoutSec";
    private static final String KEY_SEND_INTERVAL_SEC = "sendIntervalSec";
    private static final String KEY_MAX_CACHED_CRASHES = "maxCachedCrashesCount";
    private static final String KEY_RAGE_TAP_CONFIG = "rageTapConfig";
    private static final String KEY_TAP_DURATION = "tapDuration";
    private static final String KEY_DISPERSION_RADIUS = "dispersionRadius";
    private static final String KEY_TIMESPAN_DIFFERENCE = "timespanDifference";
    private static final String KEY_MINIMUM_NUMBER_OF_TAPS = "minimumNumberOfTaps";
    private static final String KEY_CAPTURE = "capture";
    private static final String KEY_TRAFFIC_CONTROL_PERCENTAGE = "trafficControlPercentage";
    private static final String KEY_GEN3_ENABLED = "gen3Enabled";
    private static final String KEY_APPLICATION_ID = "applicationId";
    private static final String KEY_REPLAY_CAPTURE = "capture";
    private static final String KEY_REPLAY_TRAFFIC_CONTROL_PERCENTAGE = "trafficControlPercentage";
    private static final String KEY_REPLAY_CRASHES_ENABLED = "crashesEnabled";
    private static final String KEY_REPLAY_RETENTION_TIME = "imageRetentionTimeInMinutes";
    private static final String KEY_REPLAY_PROTOCOL_VERSION = "protocolVersion";
    private static final String KEY_REPLAY_SELFMONITORING = "selfmonitoring";
    private static final String KEY_PIXEL_COPY_ENABLED = "pixelCopy";
    private static final String KEY_COLOR_MASKING_ENABLED = "colorMasking";
    private static final String KEY_COMPOSE_ENABLED = "composeEnabled";
    private static final String KEY_MULTIPLICITY = "multiplicity";
    private static final String KEY_SERVERID = "serverId";
    private static final String KEY_SWITCH_SERVER = "switchServer";
    private static final String KEY_STATUS = "status";
    private final String appIdEncoded;

    public ServerConfigurationManager(String appIdEncoded) {
        this.appIdEncoded = appIdEncoded;
    }

    @Override
    public ServerConfiguration fromJSON(ServerConfiguration oldServerConfig, String json) throws JSONException, ClassCastException, InvalidConfigurationException {
        ServerConfiguration.Builder newConfig;
        boolean isFullConfig;
        JSONObject rootObject = (JSONObject)new JSONTokener(json).nextValue();
        if (!rootObject.has(KEY_DYNAMIC_CONFIG)) {
            throw new InvalidConfigurationException("The configuration is missing the dynamicConfig block");
        }
        boolean bl = isFullConfig = rootObject.has(KEY_TIMESTAMP) && rootObject.has(KEY_APP_CONFIG) && rootObject.has(KEY_MOBILE_AGENT_CONFIG);
        if (!isFullConfig) {
            newConfig = oldServerConfig.newBuilder(true);
        } else {
            long newTimestamp;
            newConfig = ServerConfiguration.builder();
            try {
                newTimestamp = rootObject.getLong(KEY_TIMESTAMP);
            }
            catch (JSONException ex) {
                Utility.devLog("dtxCommunication", "parsing v3 config: timestamp must be of type long");
                return CONFIG_AGENT_ERROR;
            }
            if (newTimestamp <= oldServerConfig.getTimestamp()) {
                return oldServerConfig;
            }
            newConfig.withTimestamp(newTimestamp);
            ReplayConfiguration.Builder replayConfigBuilder = ReplayConfiguration.builder();
            JSONObject agentJsonObject = rootObject.getJSONObject(KEY_MOBILE_AGENT_CONFIG);
            this.parseMobileAgentConfigV3(newConfig, replayConfigBuilder, agentJsonObject);
            JSONObject appJsonObject = rootObject.getJSONObject(KEY_APP_CONFIG);
            try {
                this.parseAppConfigV3(newConfig, replayConfigBuilder, appJsonObject);
            }
            catch (ParseException ex) {
                return CONFIG_AGENT_ERROR;
            }
            newConfig.withReplayConfiguration(replayConfigBuilder.build());
        }
        JSONObject dynamicJsonObject = rootObject.getJSONObject(KEY_DYNAMIC_CONFIG);
        try {
            this.parseDynamicConfigV3(newConfig, dynamicJsonObject);
        }
        catch (ParseException ex) {
            return CONFIG_AGENT_ERROR;
        }
        return newConfig.build();
    }

    @Override
    public void parseMobileAgentConfigV3(ServerConfiguration.Builder serverConfigBuilder, ReplayConfiguration.Builder replayConfigBuilder, JSONObject agentJsonObject) throws JSONException {
        if (agentJsonObject.has(KEY_MAX_BEACON_SIZE_KB)) {
            serverConfigBuilder.withMaxBeaconSizeKb(this.fitOrClosest(agentJsonObject, KEY_MAX_BEACON_SIZE_KB, 10, Integer.MAX_VALUE, 150));
        }
        if (agentJsonObject.has("selfmonitoring")) {
            serverConfigBuilder.withSelfmonitoring(this.tryBooleanOrDefault(agentJsonObject, "selfmonitoring", true));
        }
        serverConfigBuilder.withSessionSplitConfiguration(this.parseSessionSplitConfiguration(agentJsonObject));
        if (agentJsonObject.has(KEY_SEND_INTERVAL_SEC)) {
            serverConfigBuilder.withSendIntervalSec(this.fitOrClosest(agentJsonObject, KEY_SEND_INTERVAL_SEC, 10, 120, 120));
        }
        if (agentJsonObject.has(KEY_MAX_CACHED_CRASHES)) {
            serverConfigBuilder.withMaxCachedCrashesCount(this.fitOrClosest(agentJsonObject, KEY_MAX_CACHED_CRASHES, 0, 100, 0));
        }
        if (agentJsonObject.has(KEY_RAGE_TAP_CONFIG)) {
            serverConfigBuilder.withRageTapConfiguration(this.parseRageTapConfiguration(agentJsonObject.getJSONObject(KEY_RAGE_TAP_CONFIG)));
        }
        if (agentJsonObject.has(KEY_REPLAY_CONFIG)) {
            JSONObject replayConfigObject = agentJsonObject.getJSONObject(KEY_REPLAY_CONFIG);
            if (replayConfigObject.has(KEY_REPLAY_PROTOCOL_VERSION)) {
                replayConfigBuilder.withProtocolVersion(this.fitOrClosest(replayConfigObject, KEY_REPLAY_PROTOCOL_VERSION, 1, Short.MAX_VALUE, 1));
            }
            if (replayConfigObject.has("selfmonitoring")) {
                replayConfigBuilder.withSelfMonitoring(this.fitOrClosest(replayConfigObject, "selfmonitoring", 0, Integer.MAX_VALUE, 0));
            }
            if (replayConfigObject.has(KEY_PIXEL_COPY_ENABLED)) {
                replayConfigBuilder.withPixelCopyEnabled(this.tryBooleanOrDefault(replayConfigObject, KEY_PIXEL_COPY_ENABLED, false));
            }
            if (replayConfigObject.has(KEY_COLOR_MASKING_ENABLED)) {
                replayConfigBuilder.withColorMaskingEnabled(this.tryBooleanOrDefault(replayConfigObject, KEY_COLOR_MASKING_ENABLED, false));
            }
            if (replayConfigObject.has(KEY_COMPOSE_ENABLED)) {
                replayConfigBuilder.withComposeEnabled(this.tryBooleanOrDefault(replayConfigObject, KEY_COMPOSE_ENABLED, true));
            }
        }
    }

    @Override
    public void parseAppConfigV3(ServerConfiguration.Builder serverConfigBuilder, ReplayConfiguration.Builder replayConfigBuilder, JSONObject appConfigJson) throws JSONException, ParseException {
        String appId;
        if (appConfigJson.has(KEY_APPLICATION_ID) && !this.appIdEncoded.equals(appId = appConfigJson.getString(KEY_APPLICATION_ID))) {
            throw new ParseException("No application id", 0);
        }
        if (appConfigJson.has("capture")) {
            serverConfigBuilder.withCapture(this.fitOrDefault(appConfigJson, "capture", 0, 1, 1));
        }
        if (appConfigJson.has("trafficControlPercentage")) {
            serverConfigBuilder.withTrafficControlPercentage(this.fitOrDefault(appConfigJson, "trafficControlPercentage", 1, 100, 100));
        }
        if (appConfigJson.has(KEY_GEN3_ENABLED)) {
            serverConfigBuilder.withGen3Enabled(this.tryBooleanOrDefault(appConfigJson, KEY_GEN3_ENABLED, false));
        }
        if (appConfigJson.has(KEY_REPLAY_CONFIG)) {
            JSONObject replayConfigObject = appConfigJson.getJSONObject(KEY_REPLAY_CONFIG);
            if (replayConfigObject.has("capture")) {
                replayConfigBuilder.withCapture(this.tryBooleanOrDefault(replayConfigObject, "capture", false));
            }
            if (replayConfigObject.has(KEY_REPLAY_CRASHES_ENABLED)) {
                replayConfigBuilder.withCrashesEnabled(this.tryBooleanOrDefault(replayConfigObject, KEY_REPLAY_CRASHES_ENABLED, false));
                replayConfigBuilder.withFullSessionConfigReceived(true);
            }
            if (replayConfigObject.has("trafficControlPercentage")) {
                replayConfigBuilder.withTrafficControlPercentage(this.fitOrDefault(replayConfigObject, "trafficControlPercentage", 0, 100, 0, 100));
            }
            if (replayConfigObject.has(KEY_REPLAY_RETENTION_TIME)) {
                replayConfigBuilder.withRetentionTimeInMinutes(this.fitOrClosest(replayConfigObject, KEY_REPLAY_RETENTION_TIME, 0, Integer.MAX_VALUE, 0));
            }
        }
    }

    @Override
    public void parseDynamicConfigV3(ServerConfiguration.Builder configuration, JSONObject dynamicConfigJson) throws JSONException, ParseException {
        String status;
        if (dynamicConfigJson.has(KEY_STATUS) && (status = dynamicConfigJson.getString(KEY_STATUS)).compareToIgnoreCase("ERROR") == 0) {
            throw new ParseException("Error status detected", 0);
        }
        configuration.withStatus(ServerConfiguration.Status.OK);
        if (dynamicConfigJson.has(KEY_MULTIPLICITY)) {
            configuration.withMultiplicity(this.fitOrDefault(dynamicConfigJson, KEY_MULTIPLICITY, 0, Integer.MAX_VALUE, 1));
        }
        if (dynamicConfigJson.has(KEY_SERVERID)) {
            configuration.withServerId(this.fitOrDefault(dynamicConfigJson, KEY_SERVERID, 0, Integer.MAX_VALUE, 1));
        }
        if (dynamicConfigJson.has(KEY_SWITCH_SERVER)) {
            configuration.withSwitchServer(this.tryBooleanOrDefault(dynamicConfigJson, KEY_SWITCH_SERVER, false));
        }
    }

    SessionSplitConfiguration parseSessionSplitConfiguration(JSONObject mobileAgentConfigJson) {
        SessionSplitConfiguration.Builder sessionSplitConfigBuilder = SessionSplitConfiguration.builder();
        if (mobileAgentConfigJson.has(KEY_MAX_SESSION_DURATION_MINS)) {
            sessionSplitConfigBuilder.withMaxSessionDuration(this.fitOrClosest(mobileAgentConfigJson, KEY_MAX_SESSION_DURATION_MINS, 10, Integer.MAX_VALUE, 360));
        }
        if (mobileAgentConfigJson.has(KEY_SESSION_TIMEOUT_SEC)) {
            sessionSplitConfigBuilder.withInactivityTimeout(this.fitOrClosest(mobileAgentConfigJson, KEY_SESSION_TIMEOUT_SEC, 30, Integer.MAX_VALUE, 600));
        }
        return sessionSplitConfigBuilder.build();
    }

    RageTapConfiguration parseRageTapConfiguration(JSONObject rageTapConfigObject) {
        RageTapConfiguration.Builder rageTapConfigBuilder = RageTapConfiguration.builder();
        if (rageTapConfigObject.has(KEY_TAP_DURATION)) {
            rageTapConfigBuilder.withTapDuration(this.fitOrClosest(rageTapConfigObject, KEY_TAP_DURATION, 0, Integer.MAX_VALUE, 100));
        }
        if (rageTapConfigObject.has(KEY_DISPERSION_RADIUS)) {
            rageTapConfigBuilder.withDispersionRadius(this.fitOrClosest(rageTapConfigObject, KEY_DISPERSION_RADIUS, 0, Integer.MAX_VALUE, 100));
        }
        if (rageTapConfigObject.has(KEY_TIMESPAN_DIFFERENCE)) {
            rageTapConfigBuilder.withTimespanDifference(this.fitOrClosest(rageTapConfigObject, KEY_TIMESPAN_DIFFERENCE, 0, Integer.MAX_VALUE, 300));
        }
        if (rageTapConfigObject.has(KEY_MINIMUM_NUMBER_OF_TAPS)) {
            rageTapConfigBuilder.withMinimumNumberOfTaps(this.fitOrClosest(rageTapConfigObject, KEY_MINIMUM_NUMBER_OF_TAPS, 3, Integer.MAX_VALUE, 3));
        }
        return rageTapConfigBuilder.build();
    }

    @Override
    public ServerConfiguration fromMap(Map<String, String> keyValueConfig, AgentMode agentMode) {
        ServerConfiguration.Builder newConfig = new ServerConfiguration.Builder();
        newConfig.withCapture(Utility.parseInt(keyValueConfig, "cp", 0, 1, 1, true));
        newConfig.withSendIntervalSec(Utility.parseInt(keyValueConfig, "si", 60, 540, 120));
        newConfig.withServerId(Utility.parseInt(keyValueConfig, "id", 0, Integer.MAX_VALUE, 1));
        newConfig.withMaxBeaconSizeKb(Utility.parseInt(keyValueConfig, "bl", 1, Integer.MAX_VALUE, agentMode == AgentMode.APP_MON ? 30 : 150));
        SessionSplitConfiguration splitConfig = SessionSplitConfiguration.builder().withInactivityTimeout(Utility.parseInt(keyValueConfig, "st", 0, Integer.MAX_VALUE, 600)).build();
        newConfig.withSessionSplitConfiguration(splitConfig);
        newConfig.withTrafficControlPercentage(Utility.parseInt(keyValueConfig, "tc", 1, 100, 100, true));
        newConfig.withMultiplicity(Utility.parseInt(keyValueConfig, "mp", 0, Integer.MAX_VALUE, 1, true));
        newConfig.withSelfmonitoring(Utility.parseInt(keyValueConfig, "sm", 0, 1, 1, true) == 1);
        return newConfig.build();
    }

    private boolean tryBooleanOrDefault(JSONObject jsonObject, String name, boolean defaultValue) {
        try {
            return jsonObject.getBoolean(name);
        }
        catch (JSONException e) {
            Utility.devLog("dtxCommunication", "parsing v3 config: expected JSON property \"" + name + "\" to be a Boolean, but it was not");
            return defaultValue;
        }
    }

    private int fitOrDefault(JSONObject jsonObject, String name, int lowerBorder, int higherBorder, int defaultValue) {
        return this.fitOrDefault(jsonObject, name, lowerBorder, higherBorder, defaultValue, defaultValue);
    }

    private int fitOrDefault(JSONObject jsonObject, String name, int lowerBorder, int higherBorder, int defaultMinValue, int defaultMaxValue) {
        if (jsonObject.has(name)) {
            try {
                int value = jsonObject.getInt(name);
                if (value < lowerBorder) {
                    return defaultMinValue;
                }
                if (value > higherBorder) {
                    return defaultMaxValue;
                }
                return value;
            }
            catch (JSONException e) {
                Utility.devLog("dtxCommunication", "parsing v3 config: expected JSON property \"" + name + "\" to be an Integer, but it was not");
                return defaultMinValue;
            }
        }
        return defaultMinValue;
    }

    private int fitOrClosest(JSONObject jsonObject, String name, int lowerBorder, int higherBorder, int defaultValue) {
        if (jsonObject.has(name)) {
            try {
                int value = jsonObject.getInt(name);
                return Math.max(Math.min(value, higherBorder), lowerBorder);
            }
            catch (JSONException e) {
                Utility.devLog("dtxCommunication", "parsing v3 config: expected JSON property \"" + name + "\" to be an Integer, but it was not");
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public String generateStorableConfiguration(ServerConfiguration serverConfig) throws JSONException {
        JSONObject rootObject = new JSONObject();
        rootObject.put(KEY_MOBILE_AGENT_CONFIG, (Object)this.generateMobileAgentConfiguration(serverConfig));
        rootObject.put(KEY_APP_CONFIG, (Object)this.generateAppConfiguration(serverConfig));
        rootObject.put(KEY_DYNAMIC_CONFIG, (Object)this.generateDynamicConfiguration(serverConfig));
        rootObject.put(KEY_TIMESTAMP, 0L);
        return rootObject.toString();
    }

    private JSONObject generateMobileAgentConfiguration(ServerConfiguration serverConfig) throws JSONException {
        JSONObject rootObject = new JSONObject();
        rootObject.put(KEY_MAX_BEACON_SIZE_KB, serverConfig.getMaxBeaconSizeKb());
        rootObject.put("selfmonitoring", serverConfig.isSelfmonitoring());
        SessionSplitConfiguration sessionSplitConfig = serverConfig.getSessionSplitConfiguration();
        rootObject.put(KEY_MAX_SESSION_DURATION_MINS, sessionSplitConfig.getMaxSessionDurationMinutes());
        rootObject.put(KEY_SESSION_TIMEOUT_SEC, sessionSplitConfig.getInactivityTimeoutSeconds());
        rootObject.put(KEY_SEND_INTERVAL_SEC, serverConfig.getSendIntervalSec());
        rootObject.put(KEY_MAX_CACHED_CRASHES, serverConfig.getMaxCachedCrashesCount());
        rootObject.put(KEY_RAGE_TAP_CONFIG, (Object)this.generateRageTapConfiguration(serverConfig));
        rootObject.put(KEY_REPLAY_CONFIG, (Object)this.generateReplayConfigurationMobileAgent(serverConfig));
        return rootObject;
    }

    private JSONObject generateAppConfiguration(ServerConfiguration serverConfig) throws JSONException {
        JSONObject rootObject = new JSONObject();
        rootObject.put(KEY_REPLAY_CONFIG, (Object)this.generateReplayConfigurationApp(serverConfig));
        rootObject.put(KEY_GEN3_ENABLED, serverConfig.isGen3Enabled());
        return rootObject;
    }

    private JSONObject generateReplayConfigurationMobileAgent(ServerConfiguration serverConfig) throws JSONException {
        ReplayConfiguration replayConfiguration = serverConfig.getReplayConfiguration();
        JSONObject replayConfigObject = new JSONObject();
        replayConfigObject.put(KEY_REPLAY_PROTOCOL_VERSION, replayConfiguration.getProtocolVersion());
        replayConfigObject.put(KEY_PIXEL_COPY_ENABLED, replayConfiguration.isPixelCopyEnabled());
        replayConfigObject.put(KEY_COLOR_MASKING_ENABLED, replayConfiguration.isColorMaskingEnabled());
        replayConfigObject.put(KEY_COMPOSE_ENABLED, replayConfiguration.isComposeEnabled());
        return replayConfigObject;
    }

    private JSONObject generateReplayConfigurationApp(ServerConfiguration serverConfig) throws JSONException {
        ReplayConfiguration replayConfiguration = serverConfig.getReplayConfiguration();
        JSONObject replayConfigObject = new JSONObject();
        replayConfigObject.put("capture", replayConfiguration.isCaptureOn());
        replayConfigObject.put(KEY_REPLAY_RETENTION_TIME, replayConfiguration.getRetentionTimeInMinutes());
        if (replayConfiguration.getFullSessionConfigReceived()) {
            replayConfigObject.put("trafficControlPercentage", replayConfiguration.getTrafficControlPercentage());
            replayConfigObject.put(KEY_REPLAY_CRASHES_ENABLED, replayConfiguration.getCrashesEnabled());
        }
        return replayConfigObject;
    }

    private JSONObject generateRageTapConfiguration(ServerConfiguration serverConfig) throws JSONException {
        RageTapConfiguration rageTapConfiguration = serverConfig.getRageTapConfiguration();
        JSONObject rageTapConfigObject = new JSONObject();
        rageTapConfigObject.put(KEY_TAP_DURATION, rageTapConfiguration.getTapDuration());
        rageTapConfigObject.put(KEY_DISPERSION_RADIUS, rageTapConfiguration.getDispersionRadius());
        rageTapConfigObject.put(KEY_TIMESPAN_DIFFERENCE, rageTapConfiguration.getTimespanDifference());
        rageTapConfigObject.put(KEY_MINIMUM_NUMBER_OF_TAPS, rageTapConfiguration.getMinimumNumberOfTaps());
        return rageTapConfigObject;
    }

    private JSONObject generateDynamicConfiguration(ServerConfiguration serverConfig) throws JSONException {
        JSONObject rootObject = new JSONObject();
        rootObject.put(KEY_SERVERID, serverConfig.getServerId());
        return rootObject;
    }

    public ServerConfiguration fromMemory(String json) throws InvalidConfigurationException, JSONException {
        ServerConfiguration memoryConfig = this.fromJSON(CONFIG_INIT_MEMORY, json);
        if (memoryConfig.getStatus() != ServerConfiguration.Status.OK) {
            throw new InvalidConfigurationException("unexpected status code: " + (Object)((Object)memoryConfig.getStatus()));
        }
        return memoryConfig;
    }
}

