/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.conf;

import androidx.annotation.VisibleForTesting;
import com.dynatrace.android.agent.conf.ConfigurationSubscriber;
import com.dynatrace.android.agent.util.Utility;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0017B#\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006J\u000e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006J\u001a\u0010\u0011\u001a\u00020\u000e2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00010\u0013J\u0014\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\u0013H\u0007J\u001c\u0010\u0016\u001a\u00020\u000e2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/dynatrace/android/agent/conf/ConfigurationPublisher;", "", "maxSubscribers", "", "subscribers", "", "Lcom/dynatrace/android/agent/conf/ConfigurationSubscriber;", "<init>", "(ILjava/util/Set;)V", "configurationsMap", "", "", "lock", "register", "", "subscriber", "unregister", "notify", "configChanges", "", "Lcom/dynatrace/android/agent/conf/ConfigurationPublisher$ConfigChange;", "getConfigChanges", "updateConfigChanges", "ConfigChange", "com.dynatrace.agent_release"})
@SourceDebugExtension(value={"SMAP\nConfigurationPublisher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigurationPublisher.kt\ncom/dynatrace/android/agent/conf/ConfigurationPublisher\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n477#2:97\n423#2:98\n1246#3,4:99\n*S KotlinDebug\n*F\n+ 1 ConfigurationPublisher.kt\ncom/dynatrace/android/agent/conf/ConfigurationPublisher\n*L\n68#1:97\n68#1:98\n68#1:99,4\n*E\n"})
public final class ConfigurationPublisher {
    private final int maxSubscribers;
    @NotNull
    private final Set<ConfigurationSubscriber> subscribers;
    @NotNull
    private Map<String, Object> configurationsMap;
    @NotNull
    private final Object lock;

    @JvmOverloads
    public ConfigurationPublisher(int maxSubscribers, @NotNull Set<ConfigurationSubscriber> subscribers) {
        Intrinsics.checkNotNullParameter(subscribers, (String)"subscribers");
        this.maxSubscribers = maxSubscribers;
        this.subscribers = subscribers;
        this.configurationsMap = new LinkedHashMap();
        this.lock = new Object();
    }

    public /* synthetic */ ConfigurationPublisher(int n, Set set, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 10;
        }
        if ((n2 & 2) != 0) {
            set = new LinkedHashSet();
        }
        this(n, set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void register(@NotNull ConfigurationSubscriber subscriber) {
        Intrinsics.checkNotNullParameter((Object)subscriber, (String)"subscriber");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (this.subscribers.size() < this.maxSubscribers) {
                this.subscribers.add(subscriber);
                subscriber.notify(this.configurationsMap);
            } else {
                Utility.devLog("dtxStartStop", "There are already " + this.maxSubscribers + " subscribers registered,cannot add another one: Dropping this subscriber.");
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unregister(@NotNull ConfigurationSubscriber subscriber) {
        Intrinsics.checkNotNullParameter((Object)subscriber, (String)"subscriber");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            boolean bl2 = this.subscribers.remove(subscriber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void notify(@NotNull Map<ConfigChange, ? extends Object> configChanges) {
        void $this$mapKeysTo$iv$iv;
        Intrinsics.checkNotNullParameter(configChanges, (String)"configChanges");
        Map<ConfigChange, ? extends Object> $this$mapKeys$iv = configChanges;
        boolean $i$f$mapKeys = false;
        Map<ConfigChange, ? extends Object> map2 = $this$mapKeys$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            ConfigChange key = (ConfigChange)((Object)entry.getKey());
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            String string = key.getId();
            Map map4 = map3;
            boolean bl2 = false;
            entry = it$iv$iv.getValue();
            map4.put(string, entry);
        }
        Map stringedConfigChangesMap = destination$iv$iv;
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.updateConfigChanges(stringedConfigChangesMap);
            for (ConfigurationSubscriber subscriber : this.subscribers) {
                subscriber.notify(stringedConfigChangesMap);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @VisibleForTesting(otherwise=2)
    @NotNull
    public final Map<String, Object> getConfigChanges() {
        return MapsKt.toMap(this.configurationsMap);
    }

    private final void updateConfigChanges(Map<String, ? extends Object> configChanges) {
        if (configChanges.isEmpty()) {
            this.configurationsMap.clear();
        } else {
            this.configurationsMap.putAll(configChanges);
        }
    }

    @JvmOverloads
    public ConfigurationPublisher(int maxSubscribers) {
        this(maxSubscribers, null, 2, null);
    }

    @JvmOverloads
    public ConfigurationPublisher() {
        this(0, null, 3, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/dynatrace/android/agent/conf/ConfigurationPublisher$ConfigChange;", "", "id", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getId", "()Ljava/lang/String;", "IS_3RDGEN_ENABLED", "IS_TOUCHES_ENABLED", "com.dynatrace.agent_release"})
    public static final class ConfigChange
    extends Enum<ConfigChange> {
        @NotNull
        private final String id;
        public static final /* enum */ ConfigChange IS_3RDGEN_ENABLED = new ConfigChange("3rd_gen_enabled");
        public static final /* enum */ ConfigChange IS_TOUCHES_ENABLED = new ConfigChange("touch_interaction_enabled");
        private static final /* synthetic */ ConfigChange[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private ConfigChange(String id) {
            this.id = id;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        public static ConfigChange[] values() {
            return (ConfigChange[])$VALUES.clone();
        }

        public static ConfigChange valueOf(String value) {
            return Enum.valueOf(ConfigChange.class, value);
        }

        @NotNull
        public static EnumEntries<ConfigChange> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = configChangeArray = new ConfigChange[]{ConfigChange.IS_3RDGEN_ENABLED, ConfigChange.IS_TOUCHES_ENABLED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

