/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.agent.events.enrichment;

import com.dynatrace.agent.communication.network.response.JsonExtensionKt;
import com.dynatrace.agent.di.SelfMonitoringComponent;
import com.dynatrace.agent.events.enrichment.sanitation.AttributeSanitizer;
import com.dynatrace.agent.events.enrichment.sanitation.JsonAttribute;
import com.dynatrace.agent.events.enrichment.sanitation.JsonAttributeKt;
import com.dynatrace.agent.events.enrichment.sanitation.SanitationContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\f\u0010\u0000\u001a\u00020\u0002*\u00020\u0002H\u0000\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0000\u001a\u001f\u0010\u0006\u001a\u00020\u0007*\u00020\u00022\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0000\u00a2\u0006\u0002\u0010\u000b\u001a\u0014\u0010\f\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a\u0014\u0010\u000f\u001a\u00020\u0010*\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a\u0014\u0010\u0013\u001a\u00020\u0010*\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0012H\u0000\u001a\u0014\u0010\u0015\u001a\u00020\u0016*\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0002H\u0000\u001a.\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u00022\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00120\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u00a8\u0006\u001f"}, d2={"deepCopy", "Lorg/json/JSONArray;", "Lorg/json/JSONObject;", "copyJsonValue", "", "value", "sanitizedDeepCopy", "Lcom/dynatrace/agent/events/enrichment/sanitation/SanitationContext;", "attributeSanitizers", "", "Lcom/dynatrace/agent/events/enrichment/sanitation/AttributeSanitizer;", "(Lorg/json/JSONObject;[Lcom/dynatrace/agent/events/enrichment/sanitation/AttributeSanitizer;)Lcom/dynatrace/agent/events/enrichment/sanitation/SanitationContext;", "put", "jsonAttribute", "Lcom/dynatrace/agent/events/enrichment/sanitation/JsonAttribute;", "hasCharacteristic", "", "key", "", "hasKeyIn", "namespace", "putAllAttributesOf", "", "other", "getMergedStartupEventOrNative", "nativeEvent", "cpEvent", "cpKeys", "", "selfMonitoring", "Lcom/dynatrace/agent/di/SelfMonitoringComponent;", "com.dynatrace.agent_release"})
@SourceDebugExtension(value={"SMAP\nJsonObjectExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonObjectExtensions.kt\ncom/dynatrace/agent/events/enrichment/JsonObjectExtensionsKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,187:1\n1251#2,2:188\n32#3,2:190\n32#3,2:192\n*S KotlinDebug\n*F\n+ 1 JsonObjectExtensions.kt\ncom/dynatrace/agent/events/enrichment/JsonObjectExtensionsKt\n*L\n121#1:188,2\n132#1:190,2\n171#1:192,2\n*E\n"})
public final class JsonObjectExtensionsKt {
    @NotNull
    public static final JSONArray deepCopy(@NotNull JSONArray $this$deepCopy) {
        Intrinsics.checkNotNullParameter((Object)$this$deepCopy, (String)"<this>");
        JSONArray copiedJsonArray = new JSONArray();
        int n = $this$deepCopy.length();
        for (int i = 0; i < n; ++i) {
            Object object = $this$deepCopy.get(i);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            copiedJsonArray.put(JsonObjectExtensionsKt.copyJsonValue(object));
        }
        return copiedJsonArray;
    }

    @NotNull
    public static final JSONObject deepCopy(@NotNull JSONObject $this$deepCopy) {
        Intrinsics.checkNotNullParameter((Object)$this$deepCopy, (String)"<this>");
        JSONObject copiedJson = new JSONObject();
        Iterator iterator = $this$deepCopy.keys();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"keys(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            String key = (String)iterator2.next();
            Object object = $this$deepCopy.get(key);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            copiedJson.put(key, JsonObjectExtensionsKt.copyJsonValue(object));
        }
        return copiedJson;
    }

    @NotNull
    public static final Object copyJsonValue(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = value;
        return object instanceof JSONArray ? JsonObjectExtensionsKt.deepCopy((JSONArray)value) : (object instanceof JSONObject ? JsonObjectExtensionsKt.deepCopy((JSONObject)value) : value);
    }

    @NotNull
    public static final SanitationContext sanitizedDeepCopy(@NotNull JSONObject $this$sanitizedDeepCopy, @NotNull AttributeSanitizer[] attributeSanitizers) {
        Intrinsics.checkNotNullParameter((Object)$this$sanitizedDeepCopy, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)attributeSanitizers, (String)"attributeSanitizers");
        JSONObject copiedJson = new JSONObject();
        List droppedAttributes = new ArrayList();
        Iterator iterator = $this$sanitizedDeepCopy.keys();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"keys(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            String key = (String)iterator2.next();
            Intrinsics.checkNotNull((Object)key);
            Object object = $this$sanitizedDeepCopy.get(key);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            JsonAttribute attribute = new JsonAttribute(key, JsonObjectExtensionsKt.copyJsonValue(object));
            JsonAttribute sanitizedCopy = JsonAttributeKt.applySanitizers(attribute, attributeSanitizers);
            Object object2 = sanitizedCopy != null ? JsonObjectExtensionsKt.put(copiedJson, sanitizedCopy) : Boolean.valueOf(droppedAttributes.add(attribute));
        }
        return new SanitationContext(copiedJson, droppedAttributes);
    }

    @NotNull
    public static final JSONObject put(@NotNull JSONObject $this$put, @NotNull JsonAttribute jsonAttribute) {
        Intrinsics.checkNotNullParameter((Object)$this$put, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)jsonAttribute, (String)"jsonAttribute");
        JSONObject jSONObject = $this$put.put(jsonAttribute.getKey(), jsonAttribute.getValue());
        Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"put(...)");
        return jSONObject;
    }

    public static final boolean hasCharacteristic(@NotNull JSONObject $this$hasCharacteristic, @NotNull String key) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$hasCharacteristic, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        try {
            Object value;
            bl = $this$hasCharacteristic.has(key) ? ((value = $this$hasCharacteristic.get(key)) instanceof Boolean ? (Boolean)value : false) : false;
        }
        catch (JSONException e) {
            bl = false;
        }
        return bl;
    }

    public static final boolean hasKeyIn(@NotNull JSONObject $this$hasKeyIn, @NotNull String namespace) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$hasKeyIn, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
            Iterator iterator = $this$hasKeyIn.keys();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"keys(...)");
            Sequence $this$any$iv = SequencesKt.asSequence((Iterator)iterator);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                String key = (String)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)key);
                if (!StringsKt.startsWith$default((String)key, (String)namespace, (boolean)false, (int)2, null)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public static final void putAllAttributesOf(@NotNull JSONObject $this$putAllAttributesOf, @NotNull JSONObject other) {
        Intrinsics.checkNotNullParameter((Object)$this$putAllAttributesOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Iterator iterator = other.keys();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"keys(...)");
        Iterator $this$forEach$iv = iterator;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv;
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            String key = (String)element$iv;
            boolean bl = false;
            Object value = other.get(key);
            $this$putAllAttributesOf.put(key, value);
        }
    }

    @NotNull
    public static final JSONObject getMergedStartupEventOrNative(@NotNull JSONObject nativeEvent, @NotNull JSONObject cpEvent, @NotNull List<String> cpKeys, @NotNull SelfMonitoringComponent selfMonitoring) {
        Intrinsics.checkNotNullParameter((Object)nativeEvent, (String)"nativeEvent");
        Intrinsics.checkNotNullParameter((Object)cpEvent, (String)"cpEvent");
        Intrinsics.checkNotNullParameter(cpKeys, (String)"cpKeys");
        Intrinsics.checkNotNullParameter((Object)selfMonitoring, (String)"selfMonitoring");
        long nativeStartTime = nativeEvent.optLong("start_time");
        long cpStartTime = cpEvent.optLong("start_time");
        if (cpStartTime < nativeStartTime) {
            selfMonitoring.reportLogEvent("CrossPlatformStartEventEarly", "Cross Platform app start has a smaller start time " + cpStartTime + " than native " + nativeStartTime);
            return nativeEvent;
        }
        long nativeEndTime = nativeStartTime + nativeEvent.optLong("duration");
        long cpEndTime = cpStartTime + cpEvent.optLong("duration");
        long cpOffset = cpStartTime - nativeStartTime;
        Iterator iterator = cpEvent.keys();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"keys(...)");
        Iterator $this$forEach$iv = iterator;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv;
        while (iterator2.hasNext()) {
            JSONObject jSONObject;
            Object element$iv = iterator2.next();
            String key = (String)element$iv;
            boolean bl = false;
            if (cpKeys.contains(key)) {
                Intrinsics.checkNotNull((Object)key);
                if (JsonExtensionKt.getLongOrNull(cpEvent, key) != null) {
                    long cpOffsetValue = cpEvent.getLong(key);
                    jSONObject = nativeEvent.put(key, cpOffsetValue + cpOffset);
                    continue;
                }
            }
            jSONObject = nativeEvent.put(key, cpEvent.get(key));
        }
        long maxEndTime = Math.max(nativeEndTime, cpEndTime);
        nativeEvent.put("start_time", nativeStartTime);
        nativeEvent.put("duration", maxEndTime - nativeStartTime);
        return nativeEvent;
    }
}

