/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.agent.util;

import android.content.Context;
import android.content.pm.PackageManager;
import com.dynatrace.agent.common.connectivity.LocalBuild;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.util.Utility;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u000b\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0013\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\fH\u0000\u00a2\u0006\u0002\b\u0018J\r\u0010\u0019\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u001aJ!\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u001c2\u0006\u0010\u001d\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u001eJ\u0015\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b J\u001e\u0010!\u001a\u00020\u00112\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00050\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010#\u001a\u00020\u0011H\u0002J\u001e\u0010$\u001a\u00020\u00112\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00050\f2\u0006\u0010&\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0012\u00a8\u0006'"}, d2={"Lcom/dynatrace/agent/util/RootDetector;", "", "<init>", "()V", "TEST_KEYS", "", "BINARY_SU", "BINARY_BUSYBOX", "BINARY_MAGISK", "DEVICE_PROPERTY_FORMAT", "LOG_TAG", "knownRootAppsPackages", "", "knownDangerousAppsPackages", "knownRootCloakingPackages", "suPaths", "cachedIsRooted", "", "Ljava/lang/Boolean;", "isDeviceRooted", "context", "Landroid/content/Context;", "isDeviceRootedInternal", "determineBinaryPaths", "determineBinaryPaths$com_dynatrace_agent_release", "checkTestKeys", "checkTestKeys$com_dynatrace_agent_release", "parseDeviceProperties", "", "deviceProperties", "parseDeviceProperties$com_dynatrace_agent_release", "checkPotentialRootApps", "checkPotentialRootApps$com_dynatrace_agent_release", "isAnyPackageFromListInstalled", "packages", "checkSuExists", "checkBinary", "directories", "fileName", "com.dynatrace.agent_release"})
@SourceDebugExtension(value={"SMAP\nRootDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RootDetector.kt\ncom/dynatrace/agent/util/RootDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,283:1\n774#2:284\n865#2,2:285\n1755#2,3:292\n693#3:287\n726#3,4:288\n*S KotlinDebug\n*F\n+ 1 RootDetector.kt\ncom/dynatrace/agent/util/RootDetector\n*L\n178#1:284\n178#1:285,2\n235#1:292,3\n216#1:287\n216#1:288,4\n*E\n"})
public final class RootDetector {
    @NotNull
    public static final RootDetector INSTANCE = new RootDetector();
    @NotNull
    private static final String TEST_KEYS = "test-keys";
    @NotNull
    private static final String BINARY_SU = "su";
    @NotNull
    private static final String BINARY_BUSYBOX = "busybox";
    @NotNull
    private static final String BINARY_MAGISK = "magisk";
    @NotNull
    private static final String DEVICE_PROPERTY_FORMAT = "\\[(.*?)]:\\s*\\[(.*?)]";
    @NotNull
    private static final String LOG_TAG = Global.LOG_PREFIX + "RootDetector";
    @NotNull
    private static final List<String> knownRootAppsPackages;
    @NotNull
    private static final List<String> knownDangerousAppsPackages;
    @NotNull
    private static final List<String> knownRootCloakingPackages;
    @NotNull
    private static final List<String> suPaths;
    @Nullable
    private static Boolean cachedIsRooted;

    private RootDetector() {
    }

    public final boolean isDeviceRooted(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (cachedIsRooted == null) {
            cachedIsRooted = this.isDeviceRootedInternal(context);
        }
        Boolean bl = cachedIsRooted;
        if (bl == null) {
            return false;
        }
        return bl;
    }

    private final boolean isDeviceRootedInternal(Context context) {
        if (this.checkTestKeys$com_dynatrace_agent_release() || this.checkPotentialRootApps$com_dynatrace_agent_release(context)) {
            return true;
        }
        List<String> directories = this.determineBinaryPaths$com_dynatrace_agent_release();
        if (this.checkBinary(directories, BINARY_SU) || this.checkBinary(directories, BINARY_BUSYBOX) || this.checkBinary(directories, BINARY_MAGISK)) {
            if (Global.DEBUG) {
                Utility.zlogD(LOG_TAG, "suspicious file detected");
            }
            return true;
        }
        if (this.checkSuExists()) {
            if (Global.DEBUG) {
                Utility.zlogD(LOG_TAG, "su command detected");
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> determineBinaryPaths$com_dynatrace_agent_release() {
        void $this$filterTo$iv$iv;
        List paths = CollectionsKt.toMutableList((Collection)suPaths);
        String sysPaths = System.getenv("PATH");
        if (sysPaths == null || ((CharSequence)sysPaths).length() == 0) {
            return paths;
        }
        String[] stringArray = new String[]{":"};
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)sysPaths, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterator iterator = ((List)destination$iv$iv).iterator();
        while (iterator.hasNext()) {
            String path;
            String internalPath = path = (String)iterator.next();
            if (!StringsKt.endsWith$default((String)path, (String)"/", (boolean)false, (int)2, null)) {
                internalPath = path + '/';
            }
            if (paths.contains(internalPath)) continue;
            paths.add(internalPath);
        }
        return paths;
    }

    public final boolean checkTestKeys$com_dynatrace_agent_release() {
        boolean isTestKeys;
        String tags;
        String string = tags = LocalBuild.INSTANCE.getTestTags();
        boolean bl = isTestKeys = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)TEST_KEYS, (boolean)false, (int)2, null) : false;
        if (isTestKeys && Global.DEBUG) {
            Utility.zlogD(LOG_TAG, "test-keys detected");
        }
        return isTestKeys;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, String> parseDeviceProperties$com_dynatrace_agent_release(@NotNull String deviceProperties) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)deviceProperties, (String)"deviceProperties");
        Sequence $this$associateBy$iv = Regex.findAll$default((Regex)new Regex(DEVICE_PROPERTY_FORMAT), (CharSequence)deviceProperties, (int)0, (int)2, null);
        boolean $i$f$associateBy = false;
        Sequence sequence = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            MatchResult matchResult = (MatchResult)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            MatchResult it = (MatchResult)element$iv$iv;
            String string = (String)it.getGroupValues().get(1);
            boolean bl2 = false;
            String string2 = (String)it.getGroupValues().get(2);
            map2.put(string, string2);
        }
        return destination$iv$iv;
    }

    public final boolean checkPotentialRootApps$com_dynatrace_agent_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.isAnyPackageFromListInstalled(knownRootAppsPackages, context) || this.isAnyPackageFromListInstalled(knownRootCloakingPackages, context) || this.isAnyPackageFromListInstalled(knownDangerousAppsPackages, context);
    }

    private final boolean isAnyPackageFromListInstalled(List<String> packages, Context context) {
        boolean bl;
        block6: {
            PackageManager pm = context.getPackageManager();
            Iterable $this$any$iv = packages;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    String packageName = (String)element$iv;
                    boolean bl3 = false;
                    try {
                        pm.getPackageInfo(packageName, 0);
                        if (Global.DEBUG) {
                            Utility.zlogD(LOG_TAG, "detected package: " + packageName);
                        }
                        bl2 = true;
                    }
                    catch (PackageManager.NameNotFoundException e) {
                        bl2 = false;
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean checkSuExists() {
        Process process2 = null;
        try {
            String[] stringArray = new String[]{"which", BINARY_SU};
            Process process3 = Runtime.getRuntime().exec(stringArray);
            Intrinsics.checkNotNull((Object)process3);
            process2 = process3;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process2.getInputStream()));
            boolean bl = bufferedReader.readLine() != null;
            return bl;
        }
        catch (Exception ignored) {
            boolean bl = false;
            return bl;
        }
        finally {
            block5: {
                Process process4 = process2;
                if (process4 == null) break block5;
                process4.destroy();
            }
        }
    }

    private final boolean checkBinary(List<String> directories, String fileName) {
        for (String path : directories) {
            File file = new File(path, fileName);
            if (!file.exists()) continue;
            if (Global.DEBUG) {
                Utility.zlogD(LOG_TAG, "file detected: " + file);
            }
            return true;
        }
        return false;
    }

    static {
        Object[] objectArray = new String[]{"com.noshufou.android.su", "com.noshufou.android.su.elite", "eu.chainfire.supersu", "com.koushikdutta.superuser", "com.thirdparty.superuser", "com.yellowes.su", "com.topjohnwu.magisk", "com.kingroot.kinguser", "com.kingo.root", "com.smedialink.oneclickroot", "com.zhiqupk.root.global", "com.alephzain.framaroot"};
        knownRootAppsPackages = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"com.koushikdutta.rommanager", "com.koushikdutta.rommanager.license", "com.dimonvideo.luckypatcher", "com.chelpus.lackypatch", "com.ramdroid.appquarantine", "com.ramdroid.appquarantinepro", "com.android.vending.billing.InAppBillingService.COIN", "com.android.vending.billing.InAppBillingService.LUCK", "com.chelpus.luckypatcher", "com.blackmartalpha", "org.blackmart.market", "com.allinone.free", "com.repodroid.app", "org.creeplays.hack", "com.baseappfull.fwd", "com.zmapp", "com.dv.marketmod.installer", "org.mobilism.android", "com.android.wp.net.log", "com.android.camera.update", "cc.madkite.freedom", "com.solohsu.android.edxp.manager", "org.meowcat.edxposed.manager", "com.xmodgame", "com.cih.game_cih", "com.charles.lpoqasert", "catch_.me_.if_.you_.can_"};
        knownDangerousAppsPackages = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"com.devadvance.rootcloak", "com.devadvance.rootcloakplus", "de.robv.android.xposed.installer", "com.saurik.substrate", "com.zachspong.temprootremovejb", "com.amphoras.hidemyroot", "com.amphoras.hidemyrootadfree", "com.formyhm.hiderootPremium", "com.formyhm.hideroot"};
        knownRootCloakingPackages = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"/data/local/", "/data/local/bin/", "/data/local/xbin/", "/sbin/", "/su/bin/", "/system/bin/", "/system/bin/.ext/", "/system/bin/failsafe/", "/system/sd/xbin/", "/system/usr/we-need-root/", "/system/xbin/", "/cache/", "/data/", "/dev/"};
        suPaths = CollectionsKt.listOf((Object[])objectArray);
    }
}

