/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.agent.communication;

import com.dynatrace.agent.communication.network.model.RetryInfo;
import com.dynatrace.agent.storage.db.EndPointInfo;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bJ\u0013\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\u0006H\u0086\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u0006R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/dynatrace/agent/communication/RetryManager;", "", "<init>", "()V", "retryStateByEndpoint", "", "Lcom/dynatrace/agent/storage/db/EndPointInfo;", "Lcom/dynatrace/agent/communication/network/model/RetryInfo;", "getIncrementedRetryInfo", "endpoint", "reason", "", "get", "clearRetryState", "", "com.dynatrace.agent_release"})
public final class RetryManager {
    @NotNull
    private final Map<EndPointInfo, RetryInfo> retryStateByEndpoint = new LinkedHashMap();

    @NotNull
    public final RetryInfo getIncrementedRetryInfo(@NotNull EndPointInfo endpoint, @NotNull String reason) {
        RetryInfo retryInfo;
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        RetryInfo retryInfo2 = this.retryStateByEndpoint.get(endpoint);
        int existingCount = retryInfo2 != null ? retryInfo2.getCount() : 0;
        RetryInfo it = retryInfo = new RetryInfo(existingCount + 1, reason);
        boolean bl = false;
        this.retryStateByEndpoint.put(endpoint, it);
        return retryInfo;
    }

    @Nullable
    public final RetryInfo get(@NotNull EndPointInfo endpoint) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        return this.retryStateByEndpoint.get(endpoint);
    }

    public final void clearRetryState(@NotNull EndPointInfo endpoint) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        this.retryStateByEndpoint.remove(endpoint);
    }
}

