/*
 * Decompiled with CFR 0.152.
 */
package com.dooapp.gaedo.utils.date;

import java.lang.ref.SoftReference;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateFormatThreadedLoader {
    private final transient ThreadLocal<SoftReference<DateFormat>> format = new ThreadLocal();
    private final String formatString;

    public DateFormatThreadedLoader(String formatString) {
        this.formatString = formatString;
    }

    public DateFormat getFormat() {
        DateFormat result;
        SoftReference<DateFormat> softRef = this.format.get();
        if (softRef != null && (result = softRef.get()) != null) {
            return result;
        }
        result = new SimpleDateFormat(this.formatString);
        softRef = new SoftReference<DateFormat>(result);
        this.format.set(softRef);
        return result;
    }

    public String format(Date date) {
        return this.getFormat().format(date);
    }

    public Date parse(String string) throws ParseException {
        return this.getFormat().parse(string);
    }
}

