/*
 * Decompiled with CFR 0.152.
 */
package com.dooapp.gaedo.utils;

import com.dooapp.gaedo.properties.Property;
import com.dooapp.gaedo.utils.NoFromStringConversionExistsException;
import com.dooapp.gaedo.utils.UnableToBuilddURIException;
import com.dooapp.gaedo.utils.UnableToCreateObjectException;
import com.dooapp.gaedo.utils.UnableToLoadClassException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

public class Utils {
    public static Map<?, ?> generateMap(Class<?> rawContainerClass, Map<?, ?> property) {
        if (property == null) {
            if (SortedMap.class.isAssignableFrom(rawContainerClass)) {
                property = new TreeMap();
            } else if (Map.class.isAssignableFrom(rawContainerClass)) {
                property = new HashMap();
            }
        }
        return property;
    }

    public static <DataType> Collection<DataType> generateCollection(Class<?> rawContainerType, Collection<DataType> property) {
        if (property == null) {
            if (rawContainerType.isInterface()) {
                if (BlockingQueue.class.isAssignableFrom(rawContainerType)) {
                    property = new ArrayBlockingQueue<DataType>(10);
                } else if (Queue.class.isAssignableFrom(rawContainerType)) {
                    property = new ArrayBlockingQueue(10);
                } else if (NavigableSet.class.isAssignableFrom(rawContainerType)) {
                    property = new TreeSet();
                } else if (Set.class.isAssignableFrom(rawContainerType)) {
                    property = new HashSet();
                } else if (SortedSet.class.isAssignableFrom(rawContainerType)) {
                    property = new TreeSet();
                } else if (List.class.isAssignableFrom(rawContainerType)) {
                    property = new LinkedList();
                } else if (Collection.class.isAssignableFrom(rawContainerType)) {
                    property = new LinkedList();
                }
            } else {
                if (Modifier.isAbstract(rawContainerType.getModifiers())) {
                    throw new UnsupportedOperationException("are you kiddin or what ? Replace your abstract type " + rawContainerType.getName() + "by an interface, it's wayyyy better !");
                }
                try {
                    property = (ArrayBlockingQueue)rawContainerType.newInstance();
                }
                catch (Exception e) {
                    throw new UnableToCreateObjectException(e, rawContainerType);
                }
            }
        }
        return property;
    }

    public static Class<?> maybeObjectify(Class<?> toObjectify) {
        Class<?> returned = Utils.objectify(toObjectify);
        if (returned == null) {
            returned = toObjectify;
        }
        return returned;
    }

    public static String maybeObjectify(String toObjectify) {
        String returned = Utils.objectify(toObjectify);
        if (returned == null) {
            returned = toObjectify;
        }
        return returned;
    }

    public static String objectify(String toCompareClass) {
        if (Integer.TYPE.getName().equals(toCompareClass)) {
            return Integer.class.getName();
        }
        if (Long.TYPE.getName().equals(toCompareClass)) {
            return Long.class.getName();
        }
        if (Short.TYPE.getName().equals(toCompareClass)) {
            return Short.class.getName();
        }
        if (Float.TYPE.getName().equals(toCompareClass)) {
            return Float.class.getName();
        }
        if (Double.TYPE.getName().equals(toCompareClass)) {
            return Double.class.getName();
        }
        if (Byte.TYPE.getName().equals(toCompareClass)) {
            return Byte.class.getName();
        }
        if (Character.TYPE.getName().equals(toCompareClass)) {
            return Character.class.getName();
        }
        if (Boolean.TYPE.getName().equals(toCompareClass)) {
            return Boolean.class.getName();
        }
        return null;
    }

    public static String primitize(String toCompareClass) {
        if (Integer.class.getName().equals(toCompareClass)) {
            return Integer.TYPE.getName();
        }
        if (Long.class.getName().equals(toCompareClass)) {
            return Long.TYPE.getName();
        }
        if (Short.class.getName().equals(toCompareClass)) {
            return Short.TYPE.getName();
        }
        if (Float.class.getName().equals(toCompareClass)) {
            return Float.TYPE.getName();
        }
        if (Double.class.getName().equals(toCompareClass)) {
            return Double.TYPE.getName();
        }
        if (Byte.class.getName().equals(toCompareClass)) {
            return Byte.TYPE.getName();
        }
        if (Character.class.getName().equals(toCompareClass)) {
            return Character.TYPE.getName();
        }
        if (Boolean.class.getName().equals(toCompareClass)) {
            return Boolean.TYPE.getName();
        }
        return null;
    }

    public static Class primitize(Class<? extends Number> toCompareClass) {
        if (Integer.class.equals(toCompareClass)) {
            return Integer.TYPE;
        }
        if (Long.class.equals(toCompareClass)) {
            return Long.TYPE;
        }
        if (Short.class.equals(toCompareClass)) {
            return Short.TYPE;
        }
        if (Float.class.equals(toCompareClass)) {
            return Float.TYPE;
        }
        if (Double.class.equals(toCompareClass)) {
            return Double.TYPE;
        }
        if (Byte.class.equals(toCompareClass)) {
            return Byte.TYPE;
        }
        if (Character.class.equals(toCompareClass)) {
            return Character.TYPE;
        }
        if (Boolean.class.equals(toCompareClass)) {
            return Boolean.TYPE;
        }
        return null;
    }

    public static Class<?> objectify(Class<?> toCompareClass) {
        if (Integer.TYPE.equals(toCompareClass)) {
            return Integer.class;
        }
        if (Long.TYPE.equals(toCompareClass)) {
            return Long.class;
        }
        if (Short.TYPE.equals(toCompareClass)) {
            return Short.class;
        }
        if (Float.TYPE.equals(toCompareClass)) {
            return Float.class;
        }
        if (Double.TYPE.equals(toCompareClass)) {
            return Double.class;
        }
        if (Byte.TYPE.equals(toCompareClass)) {
            return Byte.class;
        }
        if (Character.TYPE.equals(toCompareClass)) {
            return Character.class;
        }
        if (Boolean.TYPE.equals(toCompareClass)) {
            return Boolean.class;
        }
        return null;
    }

    public static Map<String, String> getUppercasedMap(Property[] fields) {
        HashMap<String, String> fieldNames = new HashMap<String, String>();
        for (Property f : fields) {
            String name = f.getName();
            fieldNames.put(Utils.uppercaseFirst(name), name);
        }
        return fieldNames;
    }

    public static Map<String, Method> getUppercasedMap(Method[] methods) {
        HashMap<String, Method> fieldNames = new HashMap<String, Method>();
        for (Method method : methods) {
            if (method.getDeclaringClass().equals(Object.class)) continue;
            String name = method.getName();
            fieldNames.put(Utils.uppercaseFirst(name), method);
        }
        return fieldNames;
    }

    public static String uppercaseFirst(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public static <Type> Type fromString(String value, Class<Type> type) {
        if (String.class.equals(type)) {
            return (Type)value.toString();
        }
        if (type.isPrimitive()) {
            return (Type)Utils.fromString(value, Utils.objectify(type));
        }
        if (URI.class.equals(type)) {
            try {
                return (Type)new URI(value);
            }
            catch (URISyntaxException e) {
                throw new UnableToBuilddURIException("\"" + value + "\" can't be transformed into an URI object", e);
            }
        }
        if (Class.class.equals(type)) {
            return Utils.classFromString(value);
        }
        try {
            Constructor<Type> withString = type.getDeclaredConstructor(String.class);
            return withString.newInstance(value);
        }
        catch (Exception e) {
            try {
                Method valueOf = type.getDeclaredMethod("valueOf", String.class);
                return (Type)valueOf.invoke(null, value);
            }
            catch (Exception e1) {
                throw new NoFromStringConversionExistsException(type, e, e1);
            }
        }
    }

    private static <Type> Type classFromString(String value) {
        ClassLoader[] used;
        value = Utils.maybeObjectify(value);
        for (ClassLoader c : used = new ClassLoader[]{value.getClass().getClassLoader(), Utils.class.getClassLoader(), Thread.currentThread().getContextClassLoader()}) {
            if (c == null) continue;
            try {
                return (Type)c.loadClass(value);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        throw new UnableToLoadClassException(value, used);
    }

    public static Map<String, Method> getNameMap(Method[] methods) {
        HashMap<String, Method> methodsNames = new HashMap<String, Method>();
        for (Method method : methods) {
            if (method.getDeclaringClass().equals(Object.class)) continue;
            String name = method.getName();
            methodsNames.put(name, method);
        }
        return methodsNames;
    }

    public static Collection<Class> allClassesOf(Class<?> declaring) {
        LinkedList<Class> returned = new LinkedList<Class>();
        if (declaring != null && !declaring.equals(Object.class)) {
            returned.add(declaring);
            returned.addAll(Utils.allClassesOf(declaring.getSuperclass()));
            for (Class<?> i : declaring.getInterfaces()) {
                returned.addAll(Utils.allClassesOf(i));
            }
        }
        return returned;
    }
}

