/*
 * Decompiled with CFR 0.152.
 */
package com.dooapp.gaedo.utils;

import com.dooapp.gaedo.CrudServiceException;
import com.dooapp.gaedo.utils.MethodResolver;
import com.dooapp.gaedo.utils.UnableToCreateInvocationHandlerException;
import com.dooapp.gaedo.utils.VirtualMethodCreationException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public abstract class BasicInvocationHandler<ImplementedType, VirtualMethodResolver extends MethodResolver> {
    private final Map<Method, VirtualMethodResolver> resolvers = new HashMap<Method, VirtualMethodResolver>();
    protected final Map<Method, VirtualMethodResolver> loadedResolvers = Collections.unmodifiableMap(this.resolvers);
    protected final Class<ImplementedType> toImplement;

    public BasicInvocationHandler(Class<ImplementedType> toImplement) {
        this.toImplement = toImplement;
    }

    protected void createAllMethodResolvers(Class<?> toImplement) {
        this.createResolversForDeclaredMethods(toImplement);
        for (Class<?> parentInterface : toImplement.getInterfaces()) {
            this.createAllMethodResolvers(parentInterface);
        }
    }

    protected void createResolversForDeclaredMethods(Class<?> ... toImplement) {
        LinkedList<VirtualMethodCreationException> exceptions = new LinkedList<VirtualMethodCreationException>();
        for (Class<?> currentClassToImplement : toImplement) {
            for (Method m : currentClassToImplement.getDeclaredMethods()) {
                try {
                    this.getResolver(m);
                }
                catch (VirtualMethodCreationException e) {
                    exceptions.add(e);
                }
            }
        }
        if (exceptions.size() > 0) {
            if (exceptions.size() == 1) {
                throw (VirtualMethodCreationException)exceptions.get(0);
            }
            throw new UnableToCreateInvocationHandlerException(toImplement, exceptions);
        }
    }

    protected VirtualMethodResolver getResolver(Method method) {
        if (!this.resolvers.containsKey(method)) {
            this.resolvers.put(method, this.createResolver(method));
        }
        return (VirtualMethodResolver)((MethodResolver)this.resolvers.get(method));
    }

    protected abstract VirtualMethodResolver createResolver(Method var1) throws VirtualMethodCreationException;

    public Object invoke(Object proxy, Method invokedMethod, Object[] invokedArgs) throws Throwable {
        VirtualMethodResolver resolver = this.getResolver(invokedMethod);
        try {
            return resolver.call(invokedArgs);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CrudServiceException) {
                throw (CrudServiceException)e.getCause();
            }
            throw e;
        }
    }
}

