/*
 * Decompiled with CFR 0.152.
 */
package com.dooapp.gaedo.properties;

import com.dooapp.gaedo.properties.Property;
import com.dooapp.gaedo.properties.UnableToGetPropertyException;
import com.dooapp.gaedo.properties.UnableToSetPropertyException;
import com.dooapp.gaedo.utils.Utils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;

public class PropertyField
implements Property {
    protected final Field mapped;

    public PropertyField(Field mapped) {
        this.mapped = mapped;
        this.mapped.setAccessible(true);
    }

    @Override
    public Object fromString(String value) {
        return Utils.fromString(value, this.getType());
    }

    @Override
    public Object get(Object obj) {
        try {
            return this.mapped.get(obj);
        }
        catch (Exception e) {
            throw new UnableToGetPropertyException(this, e);
        }
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.mapped.getAnnotation(annotationClass);
    }

    @Override
    public Collection<? extends Annotation> getAnnotations() {
        return Arrays.asList(this.mapped.getAnnotations());
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.mapped.getDeclaringClass();
    }

    @Override
    public Type getGenericType() {
        return this.mapped.getGenericType();
    }

    @Override
    public String getName() {
        return this.mapped.getName();
    }

    @Override
    public Class<?> getType() {
        return this.mapped.getType();
    }

    @Override
    public boolean hasModifier(int modifier) {
        return (this.mapped.getModifiers() & modifier) != 0;
    }

    @Override
    public void set(Object obj, Object value) {
        try {
            this.mapped.set(obj, value);
        }
        catch (Exception e) {
            throw new UnableToSetPropertyException(this, e);
        }
    }

    @Override
    public String toGenericString() {
        return this.mapped.toGenericString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PropertyField [");
        if (this.mapped != null) {
            builder.append("mapped=");
            builder.append(this.mapped);
        }
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mapped == null ? 0 : this.mapped.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyField other = (PropertyField)obj;
        return !(this.mapped == null ? other.mapped != null : !this.mapped.equals(other.mapped));
    }
}

