/*
 * Decompiled with CFR 0.152.
 */
package com.dooapp.gaedo.properties;

import com.dooapp.gaedo.properties.Property;
import com.dooapp.gaedo.properties.UnableToGetPropertyException;
import com.dooapp.gaedo.properties.UnableToSetPropertyException;
import com.dooapp.gaedo.utils.Utils;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;

public class DescribedProperty
implements Property {
    private final Class<?> declaringClass;
    private final Method readMethod;
    private final Method writeMethod;
    private final Method[] methods;
    private final String name;
    private final Class<?> type;
    private final String descriptorString;

    public DescribedProperty(PropertyDescriptor descriptor, Class<?> declaringClass) {
        this.declaringClass = declaringClass;
        this.readMethod = descriptor.getReadMethod();
        this.writeMethod = descriptor.getWriteMethod();
        this.methods = new Method[]{this.readMethod, this.writeMethod};
        this.type = descriptor.getPropertyType();
        this.name = descriptor.getName();
        this.descriptorString = ((Object)descriptor).toString();
    }

    @Override
    public Object get(Object bean) {
        try {
            return this.readMethod.invoke(bean, new Object[0]);
        }
        catch (Exception e) {
            throw new UnableToGetPropertyException(this, e);
        }
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        for (Method m : this.methods) {
            if (m.getAnnotation(annotationClass) == null) continue;
            return m.getAnnotation(annotationClass);
        }
        return null;
    }

    @Override
    public Collection<? extends Annotation> getAnnotations() {
        HashSet<Annotation> returned = new HashSet<Annotation>();
        for (Method m : this.methods) {
            if (m == null) continue;
            returned.addAll(Arrays.asList(m.getAnnotations()));
        }
        return returned;
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    @Override
    public Type getGenericType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public boolean hasModifier(int modifier) {
        return modifier == 1;
    }

    @Override
    public void set(Object bean, Object value) {
        try {
            this.writeMethod.invoke(bean, value);
        }
        catch (Exception e) {
            throw new UnableToSetPropertyException(this, e);
        }
    }

    @Override
    public String toGenericString() {
        return this.descriptorString;
    }

    @Override
    public Object fromString(String value) {
        return Utils.fromString(value, this.getType());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.declaringClass == null ? 0 : this.declaringClass.hashCode());
        result = 31 * result + (this.descriptorString == null ? 0 : this.descriptorString.hashCode());
        result = 31 * result + (this.readMethod == null ? 0 : this.readMethod.hashCode());
        result = 31 * result + (this.writeMethod == null ? 0 : this.writeMethod.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DescribedProperty other = (DescribedProperty)obj;
        if (this.declaringClass == null ? other.declaringClass != null : !this.declaringClass.equals(other.declaringClass)) {
            return false;
        }
        if (this.descriptorString == null ? other.descriptorString != null : !this.descriptorString.equals(other.descriptorString)) {
            return false;
        }
        if (this.readMethod == null ? other.readMethod != null : !this.readMethod.equals(other.readMethod)) {
            return false;
        }
        return !(this.writeMethod == null ? other.writeMethod != null : !this.writeMethod.equals(other.writeMethod));
    }
}

