/*
 * Decompiled with CFR 0.152.
 */
package com.dooapp.gaedo.properties;

import com.dooapp.gaedo.properties.NoAllClassesOfException;
import com.dooapp.gaedo.properties.Property;
import com.dooapp.gaedo.utils.Utils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;

public class ClassCollectionProperty
implements Property {
    public static final String CLASSES = "classes";
    private Class declaring;
    private Collection<Class> values;
    private static Method allClassesOf;

    public ClassCollectionProperty(Class declaring) {
        this.declaring = declaring;
        this.values = Utils.allClassesOf(declaring);
    }

    @Override
    public Class<?> getDeclaringClass() {
        return Object.class;
    }

    @Override
    public String getName() {
        return CLASSES;
    }

    @Override
    public Class<?> getType() {
        return allClassesOf.getReturnType();
    }

    @Override
    public Type getGenericType() {
        return allClassesOf.getGenericReturnType();
    }

    @Override
    public Object get(Object obj) {
        return this.values;
    }

    @Override
    public String toGenericString() {
        return Object.class.getCanonicalName() + "." + CLASSES + " " + this.getGenericType().toString();
    }

    @Override
    public void set(Object bean, Object value) {
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return null;
    }

    @Override
    public Collection<? extends Annotation> getAnnotations() {
        return Collections.emptyList();
    }

    @Override
    public boolean hasModifier(int modifier) {
        if ((modifier & 0x400) != 0) {
            return false;
        }
        if ((modifier & 0x10) != 0) {
            return true;
        }
        if ((modifier & 0x200) != 0) {
            return false;
        }
        if ((modifier & 0x100) != 0) {
            return false;
        }
        if ((modifier & 2) != 0) {
            return false;
        }
        if ((modifier & 4) != 0) {
            return false;
        }
        if ((modifier & 1) != 0) {
            return true;
        }
        if ((modifier & 8) != 0) {
            return false;
        }
        if ((modifier & 0x800) != 0) {
            return false;
        }
        if ((modifier & 0x20) != 0) {
            return false;
        }
        if ((modifier & 0x80) != 0) {
            return false;
        }
        if ((modifier & 0x40) != 0) {
            return false;
        }
        return false;
    }

    @Override
    public Object fromString(String value) {
        throw new UnsupportedOperationException("method " + Property.class.getName() + "#fromString has not yet been implemented AT ALL");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.declaring == null ? 0 : this.declaring.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassCollectionProperty other = (ClassCollectionProperty)obj;
        return !(this.declaring == null ? other.declaring != null : !this.declaring.getCanonicalName().equals(other.declaring.getCanonicalName()));
    }

    static {
        try {
            allClassesOf = Utils.class.getDeclaredMethod("allClassesOf", Class.class);
        }
        catch (Exception e) {
            throw new NoAllClassesOfException(Utils.class.getCanonicalName(), e);
        }
    }
}

