/*
 * Decompiled with CFR 0.152.
 */
package com.dooapp.gaedo.properties;

import com.dooapp.gaedo.properties.Property;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractPropertyAdapter
implements Property {
    private Map<Class<?>, Annotation> annotations = new HashMap();
    private Class<?> declaringClass;
    private Type genericType;
    private int modifiers;
    private String name;
    private Class<?> type;

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractPropertyAdapter other = (AbstractPropertyAdapter)obj;
        if (this.declaringClass == null ? other.declaringClass != null : !this.declaringClass.equals(other.declaringClass)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return (T)this.annotations.get(annotationClass);
    }

    @Override
    public Collection<? extends Annotation> getAnnotations() {
        return this.annotations.values();
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    @Override
    public Type getGenericType() {
        return this.genericType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.declaringClass == null ? 0 : this.declaringClass.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    @Override
    public boolean hasModifier(int modifier) {
        return (this.modifiers & modifier) != 0;
    }

    public void setAnnotation(Annotation a) {
        this.annotations.put(a.annotationType(), a);
    }

    public void setDeclaringClass(Class<?> declaringClass) {
        this.declaringClass = declaringClass;
    }

    public AbstractPropertyAdapter withDeclaringClass(Class<?> declaringClass) {
        this.setDeclaringClass(declaringClass);
        return this;
    }

    public void setGenericType(Type genericType) {
        this.genericType = genericType;
    }

    public AbstractPropertyAdapter withGenericType(Type genericType) {
        this.setGenericType(genericType);
        return this;
    }

    public void setModifier(int modifierFlag, boolean enabled) {
        this.modifiers = enabled ? (this.modifiers |= modifierFlag) : (this.modifiers &= ~modifierFlag);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public AbstractPropertyAdapter withType(Class<?> type) {
        this.setType(type);
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AbstractPropertyAdapter [");
        if (this.getDeclaringClass() != null) {
            builder.append("getDeclaringClass()=");
            builder.append(this.getDeclaringClass());
            builder.append(", ");
        }
        if (this.getName() != null) {
            builder.append("getName()=");
            builder.append(this.getName());
            builder.append(", ");
        }
        if (this.getGenericType() != null) {
            builder.append("getGenericType()=");
            builder.append(this.getGenericType());
        }
        builder.append("]");
        return builder.toString();
    }
}

