/*
 * Decompiled with CFR 0.152.
 */
package com.dooapp.gaedo.finders.sort;

import com.dooapp.gaedo.CrudServiceException;
import com.dooapp.gaedo.finders.FieldInformer;
import com.dooapp.gaedo.finders.SortingExpression;
import java.util.Comparator;
import java.util.Map;

public class SortingBackedComparator<DataType>
implements Comparator<DataType> {
    private SortingExpression sortingExpression;

    public SortingBackedComparator(SortingExpression sortingExpression) {
        this.sortingExpression = sortingExpression;
    }

    @Override
    public int compare(DataType o1, DataType o2) {
        try {
            for (Map.Entry entry : this.sortingExpression) {
                Comparable firstValue = (Comparable)((FieldInformer)entry.getKey()).getField().get(o1);
                Comparable secondValue = (Comparable)((FieldInformer)entry.getKey()).getField().get(o2);
                int value = firstValue.compareTo(secondValue);
                if (entry.getValue() == SortingExpression.Direction.Descending) {
                    value *= -1;
                }
                if (value == 0) continue;
                return value;
            }
        }
        catch (Exception e) {
            throw new UnableToCompareObjectsException(e);
        }
        return 0;
    }

    public static class UnableToCompareObjectsException
    extends CrudServiceException {
        public UnableToCompareObjectsException(Throwable cause) {
            super(cause);
        }
    }
}

