/*
 * Decompiled with CFR 0.152.
 */
package com.dooapp.gaedo.finders.root;

import com.dooapp.gaedo.finders.FieldInformer;
import com.dooapp.gaedo.finders.FieldInformerAPI;
import com.dooapp.gaedo.finders.Informer;
import com.dooapp.gaedo.finders.QueryExpression;
import com.dooapp.gaedo.finders.expressions.EqualsExpression;
import com.dooapp.gaedo.finders.root.NoSuchFieldInHierarchyException;
import com.dooapp.gaedo.finders.root.ReflectionBackedInformerFactory;
import com.dooapp.gaedo.properties.Property;
import com.dooapp.gaedo.properties.PropertyProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class ReflectionBackedInformer<DataType>
implements Informer<DataType> {
    private static final Logger logger = Logger.getLogger(ReflectionBackedInformer.class.getName());
    private Informer<? super DataType> parent;
    private final Class<DataType> informedClass;
    private Map<Property, FieldInformer> fields;
    private PropertyProvider propertyProvider;
    private ReflectionBackedInformerFactory informerFactory;

    public ReflectionBackedInformer(Class<DataType> clazz, ReflectionBackedInformerFactory reflectionBackedInformerFactory, PropertyProvider provider) {
        if (!clazz.isAssignableFrom(Object.class)) {
            this.parent = reflectionBackedInformerFactory.get(clazz.getSuperclass());
        }
        this.informedClass = clazz;
        this.propertyProvider = provider;
        this.informerFactory = reflectionBackedInformerFactory;
    }

    private Map<Property, FieldInformer> loadFieldsInformers(ReflectionBackedInformerFactory reflectionBackedInformerFactory) {
        HashMap<Property, FieldInformer> futureFields = new HashMap<Property, FieldInformer>();
        Class<DataType> currentClass = this.informedClass;
        while (!Object.class.equals(currentClass)) {
            Property[] fieldsArray;
            for (Property f : fieldsArray = this.propertyProvider.get(currentClass)) {
                if (f.hasModifier(8)) {
                    logger.fine("field " + f.toGenericString() + " will be ignored as it is a static one");
                    continue;
                }
                if (f.hasModifier(128)) {
                    logger.fine("field " + f.toGenericString() + " will be ignored as it is a transient one");
                    continue;
                }
                try {
                    futureFields.put(f, reflectionBackedInformerFactory.getInformerFor(f));
                }
                catch (UnsupportedOperationException e) {
                    e.printStackTrace();
                }
            }
            currentClass = currentClass.getSuperclass();
        }
        return futureFields;
    }

    @Override
    public FieldInformer get(String string, Collection<Property> propertyPath) {
        FieldInformer returned = this.internalGet(string);
        if (returned instanceof FieldInformerAPI) {
            returned = ((FieldInformerAPI)returned).with(new LinkedList<Property>(propertyPath));
        }
        return returned;
    }

    @Override
    public FieldInformer get(String string) {
        return this.get(string, new LinkedList<Property>());
    }

    public FieldInformer internalGet(String string) {
        if (this.fields == null) {
            this.fields = this.loadFieldsInformers(this.informerFactory);
        }
        for (Map.Entry<Property, FieldInformer> f : this.fields.entrySet()) {
            if (f.getKey().getName().equals(string)) {
                return f.getValue();
            }
            if (!(this.informedClass.getSimpleName() + "." + f.getKey().getName()).equals(string)) continue;
            return f.getValue();
        }
        if (this.parent != null) {
            try {
                return this.parent.get(string);
            }
            catch (NoSuchFieldInHierarchyException noSuchFieldInHierarchyException) {
                // empty catch block
            }
        }
        return this.informerFactory.noSuchFieldInHiearchy(this, string);
    }

    @Override
    public QueryExpression equalsTo(Object value) {
        return new EqualsExpression(null, new LinkedList<Property>(), value);
    }

    @Override
    public Informer asField(Property field) {
        return new AsFieldInformer(field);
    }

    @Override
    public Property getField() {
        throw new UnsupportedOperationException("No field can be associated to a ReflectionBackedInformer, which only describes a root object");
    }

    @Override
    public Collection<FieldInformer> getAllFieldInformers() {
        LinkedList<FieldInformer> toReturn = new LinkedList<FieldInformer>();
        if (this.parent != null) {
            toReturn.addAll(this.parent.getAllFieldInformers());
        }
        if (this.fields == null) {
            this.fields = this.loadFieldsInformers(this.informerFactory);
        }
        toReturn.addAll(this.fields.values());
        return toReturn;
    }

    @Override
    public Collection<Property> getAllFields() {
        LinkedList<Property> toReturn = new LinkedList<Property>();
        if (this.parent != null) {
            toReturn.addAll(this.parent.getAllFields());
        }
        if (this.fields == null) {
            this.fields = this.loadFieldsInformers(this.informerFactory);
        }
        toReturn.addAll(this.fields.keySet());
        return toReturn;
    }

    @Override
    public Iterable<Property> getFieldPath() {
        throw new UnsupportedOperationException("method " + FieldInformer.class.getName() + "#getFieldPath has not yet been implemented AT ALL");
    }

    @Override
    public FieldInformer with(Collection<Property> propertyPath) {
        throw new UnsupportedOperationException("method " + FieldInformerAPI.class.getName() + "#use has not yet been implemented AT ALL");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.informedClass == null ? 0 : this.informedClass.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReflectionBackedInformer other = (ReflectionBackedInformer)obj;
        return !(this.informedClass == null ? other.informedClass != null : !this.informedClass.getCanonicalName().equals(other.informedClass.getCanonicalName()));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ReflectionBackedInformer [");
        if (this.informedClass != null) {
            builder.append("clazz=");
            builder.append(this.informedClass.getName());
            builder.append(", ");
        }
        if (this.fields != null) {
            builder.append("fields=");
            builder.append(this.fields.keySet());
        }
        builder.append("]");
        return builder.toString();
    }

    public Class<DataType> getInformedClass() {
        return this.informedClass;
    }

    public class AsFieldInformer
    implements Informer<DataType> {
        private Property field;
        private List<Property> parentPath = Collections.emptyList();

        public AsFieldInformer(Property field) {
            this.field = field;
        }

        @Override
        public FieldInformer get(String string, Collection<Property> propertyPath) {
            FieldInformer returned = ReflectionBackedInformer.this.get(string);
            if (returned instanceof FieldInformerAPI) {
                LinkedList<Property> newPath = new LinkedList<Property>(propertyPath);
                newPath.add(this.field);
                returned = ((FieldInformerAPI)returned).with(newPath);
            }
            return returned;
        }

        @Override
        public FieldInformer get(String string) {
            return this.get(string, this.parentPath);
        }

        @Override
        public QueryExpression equalsTo(Object value) {
            return new EqualsExpression(this.field, this.getFieldPath(), value);
        }

        @Override
        public Informer asField(Property field) {
            return ReflectionBackedInformer.this.asField(field);
        }

        @Override
        public Property getField() {
            return this.field;
        }

        @Override
        public Collection<FieldInformer> getAllFieldInformers() {
            return ReflectionBackedInformer.this.getAllFieldInformers();
        }

        @Override
        public Collection<Property> getAllFields() {
            return ReflectionBackedInformer.this.getAllFields();
        }

        @Override
        public Iterable<Property> getFieldPath() {
            LinkedList<Property> returned = new LinkedList<Property>(this.parentPath);
            returned.add(this.field);
            return returned;
        }

        @Override
        public FieldInformer with(Collection<Property> propertyPath) {
            return new AsFieldInformer(this.field);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.field == null ? 0 : this.field.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AsFieldInformer other = (AsFieldInformer)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.field == null ? other.field != null : !this.field.equals(other.field));
        }

        private ReflectionBackedInformer getOuterType() {
            return ReflectionBackedInformer.this;
        }
    }
}

