/*
 * Decompiled with CFR 0.152.
 */
package com.dooapp.gaedo.finders.root;

import com.dooapp.gaedo.CrudServiceException;
import com.dooapp.gaedo.finders.FieldInformer;
import com.dooapp.gaedo.finders.FieldInformerAPI;
import com.dooapp.gaedo.finders.FieldProjector;
import com.dooapp.gaedo.finders.Informer;
import com.dooapp.gaedo.finders.root.BadPrefixException;
import com.dooapp.gaedo.finders.root.EmptyGetDontWorkException;
import com.dooapp.gaedo.finders.root.InvocationFailedException;
import com.dooapp.gaedo.finders.root.MethodConstructedOnMissingField;
import com.dooapp.gaedo.finders.root.NoSuchFieldInHierarchyException;
import com.dooapp.gaedo.finders.root.ReturnTypeMismatchException;
import com.dooapp.gaedo.finders.root.SubInformerMethodResolver;
import com.dooapp.gaedo.finders.root.Validable;
import com.dooapp.gaedo.patterns.Proxied;
import com.dooapp.gaedo.utils.BasicInvocationHandler;
import com.dooapp.gaedo.utils.CallMethodResolver;
import com.dooapp.gaedo.utils.MethodResolver;
import com.dooapp.gaedo.utils.VirtualMethodCreationException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.logging.Logger;

public class InformerClassInvocationHandler<InformerType extends Informer<ContainedType>, ContainedType>
extends BasicInvocationHandler<InformerType, MethodResolver>
implements InvocationHandler,
Proxied,
Validable {
    private static Logger logger = Logger.getLogger(InformerClassInvocationHandler.class.getName());
    static final String SYNTHETIC_GETTER_PREFIX = "get";
    protected final Class<ContainedType> containedType;
    protected final Class<InformerType> informerClass;
    protected final Informer<ContainedType> realInformer;

    public static <ContainedType> FieldInformer methodNameToFieldInformer(Method method, Informer<ContainedType> realInformer) {
        String methodName = method.getName();
        if (methodName.startsWith(SYNTHETIC_GETTER_PREFIX)) {
            String fieldName = methodName.substring(SYNTHETIC_GETTER_PREFIX.length());
            if (fieldName.length() > 0) {
                String realFieldName = fieldName.substring(0, 1).toLowerCase();
                if (fieldName.length() > 1) {
                    realFieldName = realFieldName + fieldName.substring(1);
                }
                try {
                    return realInformer.get(realFieldName);
                }
                catch (NoSuchFieldInHierarchyException e) {
                    throw new MethodConstructedOnMissingField(method, realFieldName, e);
                }
            }
            throw new EmptyGetDontWorkException(method);
        }
        throw new BadPrefixException(method);
    }

    public static <ContainedType> FieldInformer methodNameToFieldInformer(String methodName, Informer<ContainedType> realInformer) {
        if (methodName.startsWith(SYNTHETIC_GETTER_PREFIX)) {
            String fieldName = methodName.substring(SYNTHETIC_GETTER_PREFIX.length());
            if (fieldName.length() > 0) {
                String realFieldName = fieldName.substring(0, 1).toLowerCase();
                if (fieldName.length() > 1) {
                    realFieldName = realFieldName + fieldName.substring(1);
                }
                return realInformer.get(realFieldName);
            }
            throw new EmptyGetDontWorkException(methodName);
        }
        throw new BadPrefixException(methodName);
    }

    public InformerClassInvocationHandler(Class<InformerType> informerClass, Class<ContainedType> containedType, Informer<ContainedType> informer) {
        super(informerClass);
        this.informerClass = informerClass;
        this.containedType = containedType;
        this.realInformer = informer;
    }

    @Override
    protected MethodResolver createResolver(Method method) throws VirtualMethodCreationException {
        Class<Informer> declaringClass = method.getDeclaringClass();
        if (declaringClass.equals(FieldProjector.class)) {
            return new CallMethodResolver(method){

                @Override
                protected Object callMethod(Method method, Object[] invokedArgs) throws Throwable {
                    return InformerClassInvocationHandler.this.invokeProjectorMethod(method, invokedArgs);
                }
            };
        }
        if (declaringClass.equals(FieldInformerAPI.class)) {
            return new CallMethodResolver(method){

                @Override
                protected Object callMethod(Method method, Object[] invokedArgs) throws Throwable {
                    return InformerClassInvocationHandler.this.invokeAPIMethod(method, invokedArgs);
                }
            };
        }
        if (declaringClass.equals(Validable.class)) {
            return new CallMethodResolver(method){

                @Override
                protected Object callMethod(Method method, Object[] invokedArgs) {
                    return InformerClassInvocationHandler.this.invokeValidableMethod(method, invokedArgs);
                }
            };
        }
        if (declaringClass.equals(Proxied.class)) {
            return new CallMethodResolver(method){

                @Override
                protected Object callMethod(Method method, Object[] invokedArgs) {
                    return InformerClassInvocationHandler.this.invokeProxiedMethod(method, invokedArgs);
                }
            };
        }
        if (declaringClass.isAssignableFrom(Informer.class)) {
            return new CallMethodResolver(method){

                @Override
                protected Object callMethod(Method method, Object[] invokedArgs) {
                    return InformerClassInvocationHandler.this.invokeInformerMethod(method, invokedArgs);
                }
            };
        }
        return this.createSubInformerResolvers(method);
    }

    protected Object invokeValidableMethod(Method invokedMethod, Object[] invokedArgs) {
        try {
            return invokedMethod.invoke((Object)this, invokedArgs);
        }
        catch (IllegalArgumentException e) {
            throw new InvocationFailedException(e);
        }
        catch (IllegalAccessException e) {
            throw new InvocationFailedException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CrudServiceException) {
                throw (CrudServiceException)e.getTargetException();
            }
            throw new InvocationFailedException(e);
        }
    }

    private MethodResolver createSubInformerResolvers(Method method) {
        FieldInformer returned = InformerClassInvocationHandler.methodNameToFieldInformer(method, this.realInformer);
        Class<?> returnType = method.getReturnType();
        if (!returnType.isAssignableFrom(returned.getClass())) {
            throw new ReturnTypeMismatchException(method, returned.getClass(), returnType);
        }
        return new SubInformerMethodResolver(returned, this.realInformer);
    }

    public Class<ContainedType> getContainedType() {
        return this.containedType;
    }

    public Class<InformerType> getInformerClass() {
        return this.informerClass;
    }

    public Informer<ContainedType> getRealInformer() {
        return this.realInformer;
    }

    private Object invokeInformerMethod(Method invokedMethod, Object[] invokedArgs) {
        try {
            return invokedMethod.invoke(this.realInformer, invokedArgs);
        }
        catch (Exception e) {
            throw new InvocationFailedException(e);
        }
    }

    protected Object invokeAPIMethod(Method method, Object[] invokedArgs) throws Throwable {
        return this.invokeProjectorMethod(method, invokedArgs);
    }

    private Object invokeProjectorMethod(Method invokedMethod, Object[] invokedArgs) throws Throwable {
        Informer asField = (Informer)invokedMethod.invoke(this.realInformer, invokedArgs);
        return Proxy.newProxyInstance(this.informerClass.getClassLoader(), new Class[]{this.informerClass}, new InformerClassInvocationHandler<InformerType, ContainedType>(this.informerClass, this.containedType, asField));
    }

    private Object invokeProxiedMethod(Method invokedMethod, Object[] invokedArgs) {
        try {
            return invokedMethod.invoke((Object)this, invokedArgs);
        }
        catch (Exception e) {
            throw new InvocationFailedException(e);
        }
    }

    public String toString() {
        StringBuilder sOut = new StringBuilder();
        sOut.append(this.getClass().getName()).append("(");
        sOut.append("informerClass:").append(this.getInformerClass().getName());
        sOut.append("; containedType:").append(this.getContainedType().toString());
        sOut.append("; realInformer:").append(this.getRealInformer().getClass().getName());
        sOut.append(")");
        return sOut.toString();
    }

    @Override
    public void validate() {
        this.createAllMethodResolvers(this.informerClass);
    }
}

