/*
 * Decompiled with CFR 0.152.
 */
package com.dooapp.gaedo.finders.root;

import com.dooapp.gaedo.CrudServiceException;
import com.dooapp.gaedo.finders.FieldInformer;
import com.dooapp.gaedo.finders.root.FieldInformerLocator;
import com.dooapp.gaedo.finders.root.NoLocatorAllowsFieldException;
import com.dooapp.gaedo.properties.Property;
import java.util.HashMap;
import java.util.Map;

public class DelegatingInformerLocator
implements FieldInformerLocator {
    private FieldInformerLocator first;
    private FieldInformerLocator second;

    public DelegatingInformerLocator(FieldInformerLocator firstLocator, FieldInformerLocator secondLocator) {
        this.first = firstLocator;
        this.second = secondLocator;
    }

    private Map<FieldInformerLocator, Exception> map(CrudServiceException e1, CrudServiceException e2) {
        HashMap<FieldInformerLocator, Exception> returned = new HashMap<FieldInformerLocator, Exception>();
        returned.put(this.first, e1);
        returned.put(this.second, e2);
        return returned;
    }

    @Override
    public FieldInformer getInformerFor(Property field) {
        try {
            return this.first.getInformerFor(field);
        }
        catch (CrudServiceException e1) {
            try {
                return this.second.getInformerFor(field);
            }
            catch (CrudServiceException e2) {
                throw new NoLocatorAllowsFieldException(field, this.map(e1, e2));
            }
        }
    }

    @Override
    public FieldInformer getInformerFor(Class informedClass, String fieldName) {
        try {
            return this.first.getInformerFor(informedClass, fieldName);
        }
        catch (CrudServiceException e1) {
            try {
                return this.second.getInformerFor(informedClass, fieldName);
            }
            catch (CrudServiceException e2) {
                throw new NoLocatorAllowsFieldException(informedClass, fieldName, this.map(e1, e2));
            }
        }
    }

    public FieldInformerLocator getFirst() {
        return this.first;
    }

    public void setFirst(FieldInformerLocator first) {
        this.first = first;
    }

    public FieldInformerLocator getSecond() {
        return this.second;
    }

    public void setSecond(FieldInformerLocator second) {
        this.second = second;
    }
}

